"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputsReducer = exports.initialInputsState = exports.createInitialInputsState = void 0;
var _fp = require("lodash/fp");
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _constants = require("./constants");
var _default_date_settings = require("../../utils/default_date_settings");
var _actions = require("./actions");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  socTrends: socTrendsUnused,
  valueReport: valueReportSettings,
  ...timeRangeSettings
} = (0, _default_date_settings.getTimeRangeSettings)(false);
const initialInputsState = exports.initialInputsState = {
  global: {
    timerange: {
      kind: 'relative',
      ...timeRangeSettings
    },
    queries: [],
    policy: (0, _default_date_settings.getIntervalSettings)(false),
    linkTo: [_constants.InputsModelId.timeline],
    query: {
      query: '',
      language: 'kuery'
    },
    filters: [],
    fullScreen: false
  },
  timeline: {
    timerange: {
      kind: 'relative',
      ...timeRangeSettings
    },
    queries: [],
    policy: (0, _default_date_settings.getIntervalSettings)(false),
    linkTo: [_constants.InputsModelId.global],
    query: {
      query: '',
      language: 'kuery'
    },
    filters: [],
    fullScreen: false
  },
  valueReport: {
    timerange: valueReportSettings,
    policy: (0, _default_date_settings.getIntervalSettings)(false),
    linkTo: []
  }
};
const createInitialInputsState = socTrendsEnabled => {
  const {
    from,
    fromStr,
    to,
    toStr,
    valueReport,
    socTrends
  } = (0, _default_date_settings.getTimeRangeSettings)();
  const {
    kind,
    duration
  } = (0, _default_date_settings.getIntervalSettings)();
  return {
    global: {
      timerange: {
        kind: 'relative',
        fromStr,
        toStr,
        from,
        to
      },
      queries: [],
      policy: {
        kind,
        duration
      },
      linkTo: [_constants.InputsModelId.timeline, ...(socTrendsEnabled ? [_constants.InputsModelId.socTrends] : [])],
      query: {
        query: '',
        language: 'kuery'
      },
      filters: [],
      fullScreen: false
    },
    timeline: {
      timerange: {
        kind: 'relative',
        fromStr,
        toStr,
        from,
        to
      },
      queries: [],
      policy: {
        kind,
        duration
      },
      linkTo: [_constants.InputsModelId.global],
      query: {
        query: '',
        language: 'kuery'
      },
      filters: [],
      fullScreen: false
    },
    valueReport: {
      timerange: valueReport,
      linkTo: [],
      policy: {
        kind,
        duration
      }
    },
    ...(socTrendsEnabled ? {
      socTrends: {
        timerange: socTrends,
        linkTo: [_constants.InputsModelId.global],
        policy: {
          kind,
          duration
        }
      }
    } : {})
  };
};
exports.createInitialInputsState = createInitialInputsState;
const inputsReducer = exports.inputsReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(initialInputsState).case(_actions.setTimelineRangeDatePicker, (state, {
  from,
  to
}) => {
  return {
    ...state,
    global: {
      ...state.global,
      // needs to be emptied, but socTrends should remain if defined
      linkTo: state.global.linkTo.filter(i => i !== _constants.InputsModelId.timeline)
    },
    timeline: {
      ...state.timeline,
      timerange: {
        kind: 'absolute',
        fromStr: undefined,
        toStr: undefined,
        from,
        to
      },
      linkTo: []
    }
  };
}).case(_actions.setAbsoluteRangeDatePicker, (state, {
  id,
  from,
  to,
  fromStr = undefined,
  toStr = undefined
}) => {
  const timerange = {
    kind: 'absolute',
    fromStr,
    toStr,
    from,
    to
  };
  return (0, _helpers.updateInputTimerange)(id, timerange, state);
}).case(_actions.setRelativeRangeDatePicker, (state, {
  id,
  fromStr,
  from,
  to,
  toStr
}) => {
  const timerange = {
    kind: 'relative',
    fromStr,
    toStr,
    from,
    to
  };
  return (0, _helpers.updateInputTimerange)(id, timerange, state);
}).case(_actions.setFullScreen, (state, {
  id,
  fullScreen
}) => {
  return (0, _helpers.updateInputFullScreen)(id, fullScreen, state);
}).case(_actions.deleteAllQuery, (state, {
  id
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    queries: state.global.queries.slice(state.global.queries.length)
  }
})).case(_actions.setQuery, (state, {
  inputId,
  id,
  inspect,
  loading,
  refetch,
  searchSessionId,
  tables
}) => (0, _helpers.upsertQuery)({
  inputId,
  id,
  inspect,
  loading,
  refetch,
  state,
  searchSessionId,
  tables
})).case(_actions.deleteOneQuery, (state, {
  inputId,
  id
}) => (0, _helpers.deleteOneQuery)({
  inputId,
  id,
  state
})).case(_actions.setDuration, (state, {
  id,
  duration
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    policy: {
      ...(0, _fp.get)(`${id}.policy`, state),
      duration
    }
  }
})).case(_actions.startAutoReload, (state, {
  id
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    policy: {
      ...(0, _fp.get)(`${id}.policy`, state),
      kind: 'interval'
    }
  }
})).case(_actions.stopAutoReload, (state, {
  id
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    policy: {
      ...(0, _fp.get)(`${id}.policy`, state),
      kind: 'manual'
    }
  }
})).case(_actions.toggleTimelineLinkTo, state => (0, _helpers.toggleLockTimeline)(state)).case(_actions.toggleSocTrendsLinkTo, state => (0, _helpers.toggleLockSocTrends)(state)).case(_actions.setInspectionParameter, (state, {
  id,
  inputId,
  isInspected,
  selectedInspectIndex,
  searchSessionId
}) => (0, _helpers.setIsInspected)({
  id,
  inputId,
  isInspected,
  selectedInspectIndex,
  state,
  searchSessionId
})).case(_actions.removeLinkTo, (state, linkToIds) => (0, _helpers.removeInputLink)(linkToIds, state)).case(_actions.addLinkTo, (state, linkToIds) => (0, _helpers.addInputLink)(linkToIds, state)).case(_actions.setFilterQuery, (state, {
  id,
  query,
  language
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    query: {
      query,
      language
    }
  }
})).case(_actions.setSavedQuery, (state, {
  id,
  savedQuery
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    savedQuery
  }
})).case(_actions.setSearchBarFilter, (state, {
  id,
  filters
}) => ({
  ...state,
  [id]: {
    ...(0, _fp.get)(id, state),
    filters
  }
})).build();