"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddFilter = void 0;
var _react = require("react");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddFilter = () => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const {
    filterManager
  } = data.query;
  return (0, _react.useCallback)(({
    field,
    value,
    negate
  }) => {
    filterManager.addFilters([{
      meta: {
        alias: null,
        disabled: false,
        negate: negate !== null && negate !== void 0 ? negate : false
      },
      ...(value != null ? {
        query: {
          match_phrase: {
            [field]: value
          }
        }
      } : {
        exists: {
          field
        }
      })
    }]);
  }, [filterManager]);
};
exports.useAddFilter = useAddFilter;