"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectRoute = exports.AppRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _ = require("./404");
var _helpers_access = require("../helpers_access");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/app_routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AppRoutes = exports.AppRoutes = /*#__PURE__*/_react.default.memo(({
  services,
  subPluginRoutes
}) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 3
  }
}, subPluginRoutes.map((route, index) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({
    key: `route-${index}`
  }, route, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 14
    }
  }));
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(RedirectRoute, {
  capabilities: services.application.capabilities,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 7
  }
}))));
AppRoutes.displayName = 'AppRoutes';
const RedirectRoute = exports.RedirectRoute = /*#__PURE__*/_react.default.memo(({
  capabilities
}) => {
  if ((0, _helpers_access.hasAccessToSecuritySolution)(capabilities)) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.ONBOARDING_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  if ((0, _helpers_access.hasAccessToCases)(capabilities)) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.CASES_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 10
    }
  });
});
RedirectRoute.displayName = 'RedirectRoute';