"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.v2FooterItems = void 0;
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _deeplinksManagement = require("@kbn/deeplinks-management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const v2FooterItems = exports.v2FooterItems = [{
  id: _deeplinksManagement.DATA_MANAGEMENT_NAV_ID,
  title: _links.i18nStrings.ingestAndManageData.title,
  iconV2: 'database',
  breadcrumbStatus: 'hidden',
  renderAs: 'panelOpener',
  spaceBefore: null,
  sideNavVersion: 'v2',
  children: [{
    title: _links.i18nStrings.ingestAndManageData.ingestAndIntegrations.title,
    children: [{
      link: 'integrations',
      sideNavVersion: 'v2'
    },
    // TODO: Add fleet back when it is possible to not jump to  fleet sub menu under assets
    // { link: 'fleet' },
    {
      link: 'management:ingest_pipelines'
    },
    // logstash pipeline
    {
      link: 'management:pipelines'
    }, {
      link: 'management:content_connectors'
    }]
  }, {
    title: _links.i18nStrings.ingestAndManageData.indicesAndDataStreams.title,
    children: [{
      link: 'streams'
    }, {
      link: 'management:index_management'
    }, {
      link: 'management:index_lifecycle_management'
    }, {
      link: 'management:snapshot_restore'
    }, {
      link: 'management:transform'
    }, {
      link: 'management:rollup_jobs'
    }, {
      link: 'management:data_quality'
    }]
  }]
}, {
  id: _deeplinksManagement.STACK_MANAGEMENT_NAV_ID,
  title: _links.i18nStrings.stackManagementV2.title,
  iconV2: 'gear',
  breadcrumbStatus: 'hidden',
  renderAs: 'panelOpener',
  spaceBefore: null,
  sideNavVersion: 'v2',
  children: [{
    breadcrumbStatus: 'hidden',
    children: [{
      link: 'monitoring'
    }]
  }, {
    title: _links.i18nStrings.stackManagementV2.alertsAndInsights.title,
    children: [{
      link: 'management:triggersActions'
    }, {
      link: 'management:cases'
    }, {
      link: 'management:triggersActionsConnectors'
    }, {
      link: 'management:reporting'
    }, {
      link: 'management:jobsListLink'
    }, {
      link: 'management:watcher'
    }, {
      link: 'management:maintenanceWindows'
    }, {
      id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement)
    }, {
      id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement)
    }]
  }, {
    title: _links.i18nStrings.ml.title,
    children: [{
      link: 'management:overview'
    }, {
      link: 'management:anomaly_detection'
    }, {
      link: 'management:analytics'
    }, {
      link: 'management:trained_models'
    }, {
      link: 'management:supplied_configurations'
    }]
  }, {
    title: _links.i18nStrings.stackManagement.ai.title,
    children: [{
      link: 'management:genAiSettings'
    }, {
      link: 'management:aiAssistantManagementSelection'
    }]
  }, {
    title: _links.i18nStrings.stackManagementV2.security.title,
    children: [{
      link: 'management:users'
    }, {
      link: 'management:roles'
    }, {
      link: 'management:api_keys'
    }, {
      link: 'management:role_mappings'
    }]
  }, {
    title: _links.i18nStrings.stackManagementV2.data.title,
    children: [{
      link: 'management:cross_cluster_replication'
    }, {
      link: 'management:remote_clusters'
    }, {
      link: 'management:migrate_data'
    }]
  }, {
    title: _links.i18nStrings.stackManagementV2.kibana.title,
    children: [{
      link: 'management:dataViews'
    }, {
      link: 'management:filesManagement'
    }, {
      link: 'management:objects'
    }, {
      link: 'management:tags'
    }, {
      link: 'management:search_sessions'
    }, {
      link: 'management:spaces'
    }, {
      link: 'maps'
    }, {
      link: 'visualize'
    }, {
      link: 'graph'
    }, {
      link: 'canvas'
    }, {
      link: 'management:settings'
    }]
  }, {
    title: _links.i18nStrings.stackManagement.stack.title,
    children: [{
      link: 'management:license_management'
    }, {
      link: 'management:upgrade_assistant'
    }]
  }]
}];