"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isQueryRulesetExist = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isQueryRulesetExist = async (client, rulesetId) => {
  try {
    const ruleset = await client.queryRules.getRuleset({
      ruleset_id: rulesetId
    });
    if (ruleset) {
      return true;
    }
    return false;
  } catch (error) {
    var _error$meta;
    if (((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.statusCode) === 404) return false;
    throw error;
  }
};
exports.isQueryRulesetExist = isQueryRulesetExist;