"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchQueryRulesetExist = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchQueryRulesetExist = (rulesetId, onNoConflict, onConflict) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.QUERY_RULES_QUERY_RULESET_EXISTS_KEY, rulesetId],
    queryFn: async () => {
      const {
        exists
      } = await http.get(`/internal/search_query_rules/ruleset/${rulesetId}/exists`);
      if (!exists && onNoConflict) {
        onNoConflict();
      }
      if (exists && onConflict) {
        onConflict();
      }
      return exists;
    },
    retry: false,
    refetchOnWindowFocus: false,
    enabled: !!rulesetId
  });
};
exports.useFetchQueryRulesetExist = useFetchQueryRulesetExist;