"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummarizationModel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_management_link = require("../../hooks/use_management_link");
var _elastic_llm_cost_tour = require("../elastic_llm_cost_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/summarization_panel/summarization_model.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOptionValue = model => model.connectorId + model.name;
const SummarizationModel = ({
  selectedModel,
  models,
  onSelect
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const managementLink = (0, _use_management_link.useManagementLink)((selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.connectorId) || '');
  const onChange = modelValue => {
    const newSelectedModel = models.find(model => getOptionValue(model) === modelValue);
    if (newSelectedModel) {
      onSelect(newSelectedModel);
    }
  };
  const modelsOption = (0, _react.useMemo)(() => models.map(model => ({
    value: getOptionValue(model),
    disabled: model.disabled,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: model.icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      gutterSize: "s",
      css: {
        overflow: 'hidden'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 15
      }
    }, model.name), model.showConnectorName && model.connectorName && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      css: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        textWrap: 'nowrap'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      title: model.connectorName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 19
      }
    }, model.connectorName)))),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: model.icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "column",
      "data-test-subj": `summarization_model_select_${model.connectorName}_${model.value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 15
      }
    }, model.name), model.showConnectorName && model.connectorName && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 17
      }
    }, model.connectorName)))
  })), [models]);
  const currentModel = (0, _react.useMemo)(() =>
  // find the model from the list to ensure all values present vs. what is saved in the form and loaded in local storage.
  selectedModel !== undefined ? models.find(model => model.id === selectedModel.id) : undefined, [selectedModel, models]);
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.modelSelected}_${(selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.value) || (selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.connectorType) || 'unknown'}`);
  }, [usageTracker, selectedModel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      '.euiFormLabel': {
        display: 'flex',
        alignItems: 'center'
      }
    },
    "data-test-subj": "aiConnectorTitle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.sidebar.summarizationModel.label",
      defaultMessage: "AI Connector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }), ' '),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, currentModel && currentModel.isElasticConnector ? /*#__PURE__*/_react.default.createElement(_elastic_llm_cost_tour.ElasticLLMCostTour, {
    connectorName: currentModel.connectorName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "summarizationModelSelect",
    options: modelsOption,
    valueOfSelected: selectedModel && getOptionValue(selectedModel),
    onChange: onChange,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "summarizationModelSelect",
    options: modelsOption,
    valueOfSelected: selectedModel && getOptionValue(selectedModel),
    onChange: onChange,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    target: "_blank",
    href: managementLink,
    "data-test-subj": "manageConnectorsLink",
    iconType: "wrench",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.sidebar.summarizationModel.manageConnectorLink', {
      defaultMessage: 'Manage connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }))));
};
exports.SummarizationModel = SummarizationModel;