"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
var _common = require("../../../common");
var _delete_playground_modal = require("../saved_playground/delete_playground_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/playgrounds_list/playgrounds_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PlaygroundsTable = ({
  playgroundsData,
  onChange,
  sortField,
  sortDirection
}) => {
  const [playgroundToDelete, setPlaygroundToDelete] = (0, _react.useState)(null);
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const onNavigateToPlayground = (0, _react.useCallback)(id => {
    application === null || application === void 0 ? void 0 : application.navigateToApp(_common.PLUGIN_ID, {
      path: `/p/${id}`
    });
  }, [application]);
  const onDeletePlaygroundSuccess = (0, _react.useCallback)(() => {
    setPlaygroundToDelete(null);
    queryClient.invalidateQueries({
      queryKey: [_common.SearchPlaygroundQueryKeys.PlaygroundsList]
    });
  }, [queryClient]);
  const columns = (0, _react.useMemo)(() => [{
    name: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.table.columns.name.header', {
      defaultMessage: 'Playground'
    }),
    render: ({
      id,
      name
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": `playground-link playground-link-${id}`,
      onClick: () => onNavigateToPlayground(id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, name)
  }, {
    field: 'updatedAt',
    name: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.table.columns.updatedAt.header', {
      defaultMessage: 'Updated'
    }),
    render: updatedAt => updatedAt ? (0, _eui.formatDate)(updatedAt) : '---',
    sortable: true
  }, {
    actions: [{
      name: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.table.columns.actions.delete.title', {
        defaultMessage: 'Delete'
      }),
      description: playground => _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.table.columns.actions.delete.description', {
        defaultMessage: 'Delete playground {name}',
        values: {
          name: playground.name
        }
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      'data-test-subj': 'playgroundsListTableDeleteActionButton',
      isPrimary: true,
      onClick: playground => {
        setPlaygroundToDelete(playground);
      }
    }]
  }], [onNavigateToPlayground]);
  const pageCount = (0, _react.useMemo)(() => {
    if (playgroundsData._meta.total <= playgroundsData._meta.size) return /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: playgroundsData._meta.total,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 14
      }
    });
    const start = playgroundsData._meta.size * (playgroundsData._meta.page - 1) + 1;
    let end = playgroundsData._meta.size * (playgroundsData._meta.page - 1) + playgroundsData._meta.size;
    if (end > playgroundsData._meta.total) {
      end = playgroundsData._meta.total;
    }
    return /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: start,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }), "-", /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: end,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }));
  }, [playgroundsData]);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    },
    enableAllColumns: false,
    readOnly: false
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.playgroundsList.table.resultsCount",
    defaultMessage: "Showing {pageCount} of {totalCount}",
    values: {
      pageCount,
      totalCount: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: playgroundsData._meta.total,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 25
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "playgroundsTable",
    items: playgroundsData.items,
    columns: columns,
    pagination: {
      pageIndex: playgroundsData._meta.page - 1,
      pageSize: playgroundsData._meta.size,
      totalItemCount: playgroundsData._meta.total,
      showPerPageOptions: false
    },
    sorting: sorting,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), playgroundToDelete !== null && /*#__PURE__*/_react.default.createElement(_delete_playground_modal.DeletePlaygroundModal, {
    playgroundId: playgroundToDelete.id,
    playgroundName: playgroundToDelete.name,
    onClose: () => {
      setPlaygroundToDelete(null);
    },
    onDeleteSuccess: onDeletePlaygroundSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }));
};
exports.PlaygroundsTable = PlaygroundsTable;