"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditInferenceFlyout = void 0;
var _inference_flyout_wrapper = require("@kbn/inference-endpoint-ui-common/src/components/inference_flyout_wrapper");
var _react = _interopRequireWildcard(require("react"));
var _objectUtils = require("@kbn/object-utils");
var _use_kibana = require("../../hooks/use_kibana");
var _use_inference_endpoints = require("../../hooks/use_inference_endpoints");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/edit_inference_endpoints/edit_inference_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditInferenceFlyout = ({
  onFlyoutClose,
  selectedInferenceEndpoint
}) => {
  const {
    services: {
      http,
      notifications: {
        toasts
      },
      serverless
    }
  } = (0, _use_kibana.useKibana)();
  const {
    refetch
  } = (0, _use_inference_endpoints.useQueryInferenceEndpoints)();
  const onEditSuccess = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const inferenceEndpoint = {
    config: {
      inferenceId: selectedInferenceEndpoint.inference_id,
      taskType: selectedInferenceEndpoint.task_type,
      provider: selectedInferenceEndpoint.service,
      providerConfig: (0, _objectUtils.flattenObject)(selectedInferenceEndpoint.service_settings)
    },
    secrets: {
      providerSecrets: {}
    }
  };
  return /*#__PURE__*/_react.default.createElement(_inference_flyout_wrapper.InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: true,
    enforceAdaptiveAllocations: !!serverless,
    onSubmitSuccess: onEditSuccess,
    inferenceEndpoint: inferenceEndpoint,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.EditInferenceFlyout = EditInferenceFlyout;