"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIngestSampleData = useIngestSampleData;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useIngestSampleData() {
  const {
    sampleDataIngest,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    mutate: ingestSampleData,
    isLoading
  } = (0, _reactQuery.useMutation)([_constants.QueryKeys.IngestSampleData], () => {
    if (!sampleDataIngest) {
      throw new Error(_i18n.i18n.translate('xpack.searchIndices.shared.createIndex.ingestSampleData.notInstalled', {
        defaultMessage: 'Sample Data Ingest plugin is not installed'
      }));
    }
    return sampleDataIngest.install();
  }, {
    onSuccess: () => {
      toasts === null || toasts === void 0 ? void 0 : toasts.addSuccess(_i18n.i18n.translate('xpack.searchIndices.shared.createIndex.ingestSampleData.successNotification', {
        defaultMessage: 'The Sample Data was successfully installed'
      }));
      queryClient.invalidateQueries([_constants.QueryKeys.FetchSampleDataStatus]);
    },
    onError: error => {
      var _error$body$message, _error$body;
      toasts === null || toasts === void 0 ? void 0 : toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.ingestSampleData.errorNotification', {
          defaultMessage: 'Something went wrong while installing the Sample Data'
        })
      });
    }
  });
  return {
    ingestSampleData,
    isLoading
  };
}