"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuideSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _workflows = require("../../code_examples/workflows");
var _use_guide_tour = require("./hooks/use_guide_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/guide_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GuideSelector = ({
  selectedWorkflowId,
  onChange,
  showTour
}) => {
  const {
    tourIsOpen,
    setTourIsOpen
  } = (0, _use_guide_tour.useGuideTour)();
  return showTour ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    "data-test-subj": "searchIngestTour",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.searchIndices.tourDescription', {
      defaultMessage: 'Explore additional guides for setting up your Elasticsearch index.'
    }))),
    isStepOpen: tourIsOpen,
    minWidth: 300,
    onFinish: () => setTourIsOpen(false),
    step: 1,
    stepsTotal: 1,
    title: _i18n.i18n.translate('xpack.searchIndices.tourTitle', {
      defaultMessage: 'New guides available!'
    }),
    anchorPosition: "rightUp",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "searchIngestTourCloseButton",
      color: "text",
      flush: "right",
      onClick: () => setTourIsOpen(false),
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchIndices.closeTourAction', {
      defaultMessage: 'Close tour'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(GuideSelectorTiles, {
    selectedWorkflowId: selectedWorkflowId,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(GuideSelectorTiles, {
    selectedWorkflowId: selectedWorkflowId,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.GuideSelector = GuideSelector;
const GuideSelectorTiles = ({
  selectedWorkflowId,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, _workflows.workflows.map(workflow => {
    const isSelected = selectedWorkflowId === workflow.id;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: workflow.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: workflow.title,
      hasBorder: !isSelected,
      titleSize: "xs",
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 28
        }
      }, workflow.summary),
      selectable: {
        onClick: () => onChange(workflow.id),
        isSelected
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }));
  }));
};