"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processAnyType = exports.processAllTypes = void 0;
Object.defineProperty(exports, "processEnum", {
  enumerable: true,
  get: function () {
    return _enum.processEnum;
  }
});
exports.processMap = void 0;
Object.defineProperty(exports, "processObject", {
  enumerable: true,
  get: function () {
    return _object.processObject;
  }
});
exports.processString = exports.processStream = exports.processRecord = void 0;
var _configSchema = require("@kbn/config-schema");
var _parse = require("../../parse");
var _utils = require("./utils");
var _object = require("./object");
var _enum = require("./enum");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  META_FIELD_X_OAS_MAX_LENGTH,
  META_FIELD_X_OAS_MIN_LENGTH,
  META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES
} = _configSchema.metaFields;
const processString = schema => {
  if (META_FIELD_X_OAS_MIN_LENGTH in schema) {
    schema.minLength = schema[META_FIELD_X_OAS_MIN_LENGTH];
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_MIN_LENGTH);
  }
  if (META_FIELD_X_OAS_MAX_LENGTH in schema) {
    schema.maxLength = schema[META_FIELD_X_OAS_MAX_LENGTH];
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_MAX_LENGTH);
  }
};
exports.processString = processString;
const processStream = schema => {
  schema.type = 'object';
};
exports.processStream = processStream;
const processAdditionalProperties = (ctx, schema) => {
  if (META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES in schema) {
    const fn = schema[META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES];
    const {
      result: additionalSchema
    } = (0, _parse.parse)({
      ctx,
      schema: fn()
    });
    schema.additionalProperties = additionalSchema;
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES);
  } else {
    schema.additionalProperties = true;
  }
};
const processRecord = (ctx, schema) => {
  schema.type = 'object';
  processAdditionalProperties(ctx, schema);
};
exports.processRecord = processRecord;
const processMap = (ctx, schema) => {
  schema.type = 'object';
  processAdditionalProperties(ctx, schema);
};
exports.processMap = processMap;
const processAllTypes = schema => {
  (0, _utils.processDeprecated)(schema);
  (0, _utils.processDiscontinued)(schema);
  (0, _utils.stripBadDefault)(schema);
};
exports.processAllTypes = processAllTypes;
const processAnyType = schema => {
  // Map schema to an empty object: `{}`
  for (const key of Object.keys(schema)) {
    (0, _utils.deleteField)(schema, key);
  }
};
exports.processAnyType = processAnyType;