"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailureToast = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var errors = _interopRequireWildcard(require("@kbn/reporting-common/errors"));
var _shared_i18n_texts = require("../shared_i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/notifier/job_failure.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFailureToast = (errorText, job, getManagmenetLink, docLinks, core) => {
  return {
    title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.couldNotCreateReportTitle",
      defaultMessage: "Cannot create {reportType} report for ''{reportObjectTitle}''.",
      values: {
        reportType: job.jobtype,
        reportObjectTitle: job.title
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 7
      }
    }), core),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "danger",
      "data-test-errorText": errorText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }, job.errorCode === errors.VisualReportingSoftDisabledError.code ? _shared_i18n_texts.sharedI18nTexts.cloud.insufficientMemoryError(docLinks.links.reporting.cloudMinimumRequirements) : errorText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.checkManagement",
      defaultMessage: "Go to {path} for details.",
      values: {
        path: /*#__PURE__*/_react.default.createElement("a", {
          href: getManagmenetLink(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.reporting.publicNotifier.error.reportingSectionUrlLinkLabel",
          defaultMessage: "Stack Management > Kibana > Reporting",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }))), core),
    iconType: undefined,
    'data-test-subj': 'completeReportFailure'
  };
};
exports.getFailureToast = getFailureToast;