"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostAndDistinctProbabilisticCount = getHostAndDistinctProbabilisticCount;
var _server = require("@kbn/observability-plugin/server");
var _storage_explorer = require("../../../common/storage_explorer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHostAndDistinctProbabilisticCount({
  client,
  timeFrom,
  timeTo,
  kuery,
  indexLifecyclePhase
}) {
  var _response$aggregation, _response$aggregation2;
  const response = await client.search('profiling_probabilistic_cardinality', {
    index: 'profiling-hosts',
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), {
          range: {
            '@timestamp': {
              gte: String(timeFrom),
              lt: String(timeTo),
              format: 'epoch_second'
            }
          }
        }, ...(indexLifecyclePhase !== _storage_explorer.IndexLifecyclePhaseSelectOption.All ? (0, _server.termQuery)('_tier', _storage_explorer.indexLifeCyclePhaseToDataTier[indexLifecyclePhase]) : [])]
      }
    },
    aggs: {
      hostsAndProjectIds: {
        multi_terms: {
          terms: [{
            field: 'host.id'
          }, {
            field: 'profiling.project.id'
          }]
        },
        aggs: {
          activeProbabilisticValue: {
            top_metrics: {
              metrics: {
                field: 'profiling.agent.config.probabilistic_threshold'
              },
              sort: {
                '@timestamp': 'desc'
              }
            }
          }
        }
      },
      hostCount: {
        cardinality: {
          field: 'host.id'
        }
      }
    }
  });
  const activeProbabilisticValuesPerProjectId = {};
  (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.hostsAndProjectIds.buckets.forEach(bucket => {
    var _bucket$activeProbabi, _bucket$activeProbabi2;
    const projectId = bucket.key[1];
    const activeProbabilisticValue = (_bucket$activeProbabi = bucket.activeProbabilisticValue.top[0]) === null || _bucket$activeProbabi === void 0 ? void 0 : (_bucket$activeProbabi2 = _bucket$activeProbabi.metrics) === null || _bucket$activeProbabi2 === void 0 ? void 0 : _bucket$activeProbabi2['profiling.agent.config.probabilistic_threshold'];
    if (activeProbabilisticValue) {
      const currentMap = activeProbabilisticValuesPerProjectId[projectId];
      if (currentMap) {
        currentMap.add(activeProbabilisticValue);
      } else {
        const activeProbabilisticSet = new Set();
        activeProbabilisticSet.add(activeProbabilisticValue);
        activeProbabilisticValuesPerProjectId[projectId] = activeProbabilisticSet;
      }
    }
  });
  let totalNumberOfDistinctProbabilisticValues = 0;
  Object.keys(activeProbabilisticValuesPerProjectId).forEach(projectId => {
    const activeProbabilisticValues = activeProbabilisticValuesPerProjectId[projectId];
    if (activeProbabilisticValues.size > 1) {
      totalNumberOfDistinctProbabilisticValues += activeProbabilisticValues.size;
    }
  });
  return {
    totalNumberOfDistinctProbabilisticValues,
    totalNumberOfHosts: ((_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.hostCount.value) || 0
  };
}