"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageExplorerView = StorageExplorerView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _react = _interopRequireWildcard(require("react"));
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _primary_profiling_search_bar = require("../../components/profiling_app_page_template/primary_profiling_search_bar");
var _use_async = require("../../hooks/use_async");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _data_breakdown = require("./data_breakdown");
var _distinct_probabilistic_values_warning = require("./distinct_probabilistic_values_warning");
var _host_breakdown = require("./host_breakdown");
var _index_lifecycle_phase_select = require("./index_lifecycle_phase_select");
var _summary = require("./summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StorageExplorerView() {
  var _storageExplorerSumma;
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    indexLifecyclePhase
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [selectedTab, setSelectedTab] = (0, _react.useState)('host_breakdown');
  const [loadedState, setLoadedState] = (0, _react.useState)({
    summary: false,
    hostBreakdown: false
  });
  const {
    services: {
      fetchStorageExplorerSummary
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const storageExplorerSummaryState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchStorageExplorerSummary({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery: '',
      indexLifecyclePhase
    });
  }, [fetchStorageExplorerSummary, timeRange.inSeconds.start, timeRange.inSeconds.end, indexLifecyclePhase]);
  (0, _react.useEffect)(() => {
    if (!loadedState.summary && storageExplorerSummaryState.status === _use_async.AsyncStatus.Settled) {
      setLoadedState(prevState => ({
        ...prevState,
        summary: true
      }));
    }
  }, [loadedState.summary, storageExplorerSummaryState.status, setLoadedState]);
  const totalNumberOfDistinctProbabilisticValues = ((_storageExplorerSumma = storageExplorerSummaryState.data) === null || _storageExplorerSumma === void 0 ? void 0 : _storageExplorerSumma.totalNumberOfDistinctProbabilisticValues) || 0;
  const hasDistinctProbabilisticValues = totalNumberOfDistinctProbabilisticValues > 1;
  const handleOnReady = () => {
    if (!loadedState.hostBreakdown) {
      setLoadedState(prevState => ({
        ...prevState,
        hostBreakdown: true
      }));
    }
  };
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (loadedState.hostBreakdown && loadedState.summary) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        }
      });
    }
  }, [loadedState, onPageReady, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    hideSearchBar: true,
    pageTitle: _i18n.i18n.translate('xpack.profiling.storageExplorer.title', {
      defaultMessage: 'Storage explorer'
    }),
    showBetaBadge: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      justifyContent: 'flex-end'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_index_lifecycle_phase_select.IndexLifecyclePhaseSelect, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  })))), hasDistinctProbabilisticValues && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_distinct_probabilistic_values_warning.DistinctProbabilisticValuesWarning, {
    totalNumberOfDistinctProbabilisticValues: totalNumberOfDistinctProbabilisticValues,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    data: storageExplorerSummaryState.data,
    isLoading: storageExplorerSummaryState.status === _use_async.AsyncStatus.Loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "storageExplorer_hostBreakdownTab",
    onClick: () => {
      setSelectedTab('host_breakdown');
    },
    isSelected: selectedTab === 'host_breakdown',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.tabs.hostBreakdown', {
    defaultMessage: 'Host agent breakdown'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": "storageExplorer_dataBreakdownTab",
    onClick: () => {
      setSelectedTab('data_breakdown');
    },
    isSelected: selectedTab === 'data_breakdown',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.tabs.dataBreakdown', {
    defaultMessage: 'Data breakdown'
  })))), selectedTab === 'host_breakdown' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_host_breakdown.HostBreakdown, {
    hasDistinctProbabilisticValues: hasDistinctProbabilisticValues,
    onReady: handleOnReady,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })) : null, selectedTab === 'data_breakdown' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_breakdown.DataBreakdown, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  })) : null));
}