"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingDependencies = useProfilingDependencies;
var _react = require("react");
var _profiling_dependencies_context = require("./profiling_dependencies_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingDependencies() {
  const context = (0, _react.useContext)(_profiling_dependencies_context.ProfilingDependenciesContext);
  if (!context) {
    throw new Error('ProfilingDependenciesContext not found');
  }
  return context;
}