"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseContext = void 0;
exports.LicenseProvider = LicenseProvider;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _profiling_app_page_template = require("../../profiling_app_page_template");
var _license_prompt = require("../../license_prompt");
var _use_profiling_dependencies = require("../profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/contexts/license/license_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LicenseContext = exports.LicenseContext = /*#__PURE__*/_react.default.createContext(undefined);
function LicenseProvider({
  children
}) {
  const {
    license$
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start.licensing;
  const license = (0, _useObservable.default)(license$);
  // if license is not loaded yet, consider it valid
  const hasInvalidLicense = (license === null || license === void 0 ? void 0 : license.isActive) === false;

  // if license is invalid show an error message
  if (hasInvalidLicense) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }));
  }

  // render rest of application and pass down license via context
  return /*#__PURE__*/_react.default.createElement(LicenseContext.Provider, {
    value: license,
    children: children,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 10
    }
  });
}