"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModalDashboardSelector = SaveModalDashboardSelector;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _dashboard_picker = _interopRequireDefault(require("./dashboard_picker/dashboard_picker"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/saved_object_save_modal_dashboard_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function SaveModalDashboardSelector(props) {
  const {
    documentId,
    onSelectDashboard,
    canSaveByReference,
    setAddToLibrary,
    isAddToLibrarySelected,
    dashboardOption,
    onChange,
    copyOnSave,
    hasAttemptedSubmit,
    hasSelectedDashboard
  } = props;
  const isDisabled = !copyOnSave && !!documentId;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationUtil.saveModalDashboard.addToDashboardLabel",
      defaultMessage: "Add to dashboard",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }),
    hasChildLabel: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    "data-test-subj": "add-to-dashboard-options",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'existing',
    id: "existing-dashboard-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.existingDashboardOptionLabel', {
      defaultMessage: 'Existing'
    }),
    onChange: () => onChange('existing'),
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "savAddDashboard__searchDashboards",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_picker.default, {
    isDisabled: dashboardOption !== 'existing',
    onChange: onSelectDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 19
    }
  }), hasAttemptedSubmit && dashboardOption === 'existing' && !hasSelectedDashboard ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('presentationUtil.saveModalDashboard.existingDashboardRequiredMessage', {
    defaultMessage: 'Dashboard is required'
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'new',
    id: "new-dashboard-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.newDashboardOptionLabel', {
      defaultMessage: 'New'
    }),
    onChange: () => onChange('new'),
    disabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === null,
    id: "add-to-library-option",
    name: "dashboard-option",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.noDashboardOptionLabel', {
      defaultMessage: 'None'
    }),
    onChange: () => {
      setAddToLibrary(true);
      onChange(null);
    },
    disabled: isDisabled || !canSaveByReference,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "add-to-library-checkbox",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "add-to-library-checkbox",
    label: _i18n.i18n.translate('presentationUtil.saveModalDashboard.libraryOptionLabel', {
      defaultMessage: 'Add to library'
    }),
    checked: isAddToLibrarySelected,
    disabled: dashboardOption === null || isDisabled || !canSaveByReference,
    onChange: event => setAddToLibrary(event.target.checked),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "presentationUtil.saveModalDashboard.dashboardInfoTooltip",
      defaultMessage: "Items added to the Visualize library are available to all dashboards. Edits to a library item appear everywhere it is used.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 19
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }))))));
}