"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS", {
  enumerable: true,
  get: function () {
    return _types.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS;
  }
});
exports.withSuspense = exports.LazySavedObjectSaveModalDashboardWithSaveResult = exports.LazySavedObjectSaveModalDashboard = exports.LazyLabsFlyout = exports.LazyLabsBeakerButton = exports.LazyFieldPicker = exports.LazyExpressionInput = exports.LazyDataViewPicker = exports.LazyDashboardPicker = exports.DashboardDrilldownOptionsComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("./dashboard_drilldown_options/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A HOC which supplies React.Suspense with a fallback component, and a `EuiErrorBoundary` to contain errors.
 * @param Component A component deferred by `React.lazy`
 * @param fallback A fallback component to render while things load; default is `EuiLoadingSpinner`
 */
const withSuspense = (Component, fallback = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 35
  }
})) => /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: fallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 11
    }
  }))));
});
exports.withSuspense = withSuspense;
const LazyLabsBeakerButton = exports.LazyLabsBeakerButton = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./labs/labs_beaker_button'))));
const LazyLabsFlyout = exports.LazyLabsFlyout = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./labs/labs_flyout'))));
const LazyDashboardPicker = exports.LazyDashboardPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_picker/dashboard_picker'))));
const LazySavedObjectSaveModalDashboard = exports.LazySavedObjectSaveModalDashboard = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_object_save_modal_dashboard'))));

/**
 * Used with `showSaveModal` to pass `SaveResult` back from `onSave`
 */
const LazySavedObjectSaveModalDashboardWithSaveResult = exports.LazySavedObjectSaveModalDashboardWithSaveResult = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_object_save_modal_dashboard_with_save_result'))));
const LazyDataViewPicker = exports.LazyDataViewPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_picker/data_view_picker'))));
const LazyFieldPicker = exports.LazyFieldPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./field_picker/field_picker'))));
const LazyDashboardDrilldownOptionsComponent = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_drilldown_options/dashboard_drilldown_options'))).then(({
  DashboardDrilldownOptionsComponent
}) => ({
  default: DashboardDrilldownOptionsComponent
})));
const DashboardDrilldownOptionsComponent = exports.DashboardDrilldownOptionsComponent = withSuspense(LazyDashboardDrilldownOptionsComponent, null);
/**
 * A lazily-loaded ExpressionInput component.
 */
const LazyExpressionInput = exports.LazyExpressionInput = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./expression_input'))));