"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPicker = DashboardPicker;
exports.default = void 0;
var _lodash = require("lodash");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/dashboard_picker/dashboard_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardPicker({
  isDisabled,
  onChange,
  idsToOmit
}) {
  var _selectedDashboard$la;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isLoading, setIsLoading] = (0, _react2.useState)(true);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const [dashboardHits, setDashboardHits] = (0, _react2.useState)([]);
  const [dashboardOptions, setDashboardOptions] = (0, _react2.useState)([]);
  const [query, setQuery] = (0, _react2.useState)('');
  const [debouncedQuery, setDebouncedQuery] = (0, _react2.useState)('');
  const [selectedDashboard, setSelectedDashboard] = (0, _react2.useState)(null);

  /**
   * Debounce the query to avoid many calls to content management.
   */
  const debouncedSetQuery = (0, _react2.useMemo)(() => (0, _lodash.debounce)(latestQuery => setDebouncedQuery(latestQuery), 150), []);
  (0, _react2.useEffect)(() => {
    debouncedSetQuery(query);
  }, [debouncedSetQuery, query]);

  /**
   * Run query to search for Dashboards when debounced query changes.
   */
  (0, _react2.useEffect)(() => {
    let canceled = false;
    (async () => {
      setIsLoading(true);
      const response = await _kibana_services.contentManagementService.client.search({
        contentTypeId: 'dashboard',
        query: {
          text: debouncedQuery ? `${debouncedQuery}*` : undefined,
          limit: 30
        }
      });
      if (canceled) return;
      if (response && response.hits) {
        setDashboardHits(response.hits);
      }
      setIsLoading(false);
    })();
    return () => {
      canceled = true;
    };
  }, [debouncedQuery]);

  /**
   * Format items with dashboard hits and selected option
   */
  (0, _react2.useEffect)(() => {
    setDashboardOptions(dashboardHits.filter(d => !d.managed && !(idsToOmit !== null && idsToOmit !== void 0 ? idsToOmit : []).includes(d.id)).map(d => ({
      value: d.id,
      label: d.attributes.title,
      checked: d.id === (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.value) ? 'on' : undefined,
      'data-test-subj': `dashboard-picker-option-${d.attributes.title.replaceAll(' ', '-')}`
    })));
  }, [dashboardHits, idsToOmit, selectedDashboard]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiInputPopover, {
    panelPaddingSize: "none",
    input: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      isDisabled: isDisabled,
      fullWidth: true,
      isLoading: isLoading,
      "data-test-subj": "open-dashboard-picker",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      label: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s",
        css: (0, _react.css)`
                color: ${selectedDashboard ? euiTheme.colors.textParagraph : euiTheme.colors.textDisabled};
              `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 13
        }
      }, (_selectedDashboard$la = selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.label) !== null && _selectedDashboard$la !== void 0 ? _selectedDashboard$la : _i18n.i18n.translate('presentationUtil.dashboardPicker.noDashboardOptionLabel', {
        defaultMessage: 'Select dashboard'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    fullWidth: true,
    onChange: event => setQuery(event.target.value),
    value: query,
    "data-test-subj": "dashboard-picker-search",
    placeholder: _i18n.i18n.translate('presentationUtil.dashboardPicker.searchDashboardPlaceholder', {
      defaultMessage: 'Search dashboards...'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    options: dashboardOptions,
    onChange: (newOptions, event, selected) => {
      setIsPopoverOpen(false);
      if (!selected || selected.value === (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.value)) return;
      setSelectedDashboard(selected);
      onChange({
        name: selected.label,
        id: selected.value
      });
    },
    renderOption: option => /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
      search: query,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 35
      }
    }, option.label),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 20
    }
  }, list)));
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DashboardPicker;