"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConversationsService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  async list({
    agentId
  }) {
    const response = await this.http.get(`${_constants.publicApiPath}/conversations`, {
      query: {
        agent_id: agentId
      }
    });
    return response.results;
  }
  async get({
    conversationId
  }) {
    return await this.http.get(`${_constants.publicApiPath}/conversations/${conversationId}`);
  }
  async delete({
    conversationId
  }) {
    return await this.http.delete(`${_constants.publicApiPath}/conversations/${conversationId}`);
  }
}
exports.ConversationsService = ConversationsService;