"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBuilderSettingsApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _i18n = require("@kbn/i18n");
var _bottom_bar_actions = require("./bottom_bar_actions");
var _use_editable_settings = require("../hooks/use_editable_settings");
var _i18n2 = require("../../application/utils/i18n");
var _use_kibana = require("../../application/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/management/components/agent_builder_settings_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentBuilderSettingsApp = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const settingsKeys = [_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID];
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _use_editable_settings.useEditableSettings)(settingsKeys);
  async function handleSave() {
    try {
      await saveAll();
      window.location.reload();
    } catch (e) {
      var _services$notificatio;
      (_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.onechat.management.agentBuilder.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: e instanceof Error ? e.message : String(e)
      });
    }
  }
  const hasInvalidChanges = Object.values(unsavedChanges).some(({
    isInvalid
  }) => isInvalid);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "agentBuilderSettingsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, _i18n2.labels.management.agentBuilder)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowKibanaProvider, {
    docLinks: {
      links: {
        management: services.docLinks.links.management
      }
    },
    notifications: {
      toasts: services.notifications.toasts
    },
    settings: {
      client: services.settings.client
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, settingsKeys.map(settingKey => {
    var _services$application, _services$application2, _services$application3;
    const field = fields[settingKey];
    if (!field) return null;
    return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
      key: settingKey,
      field: field,
      isSavingEnabled: !!((_services$application = services.application) !== null && _services$application !== void 0 && (_services$application2 = _services$application.capabilities) !== null && _services$application2 !== void 0 && (_services$application3 = _services$application2.advancedSettings) !== null && _services$application3 !== void 0 && _services$application3.save),
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 17
      }
    });
  })))), /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    areChangesInvalid: hasInvalidChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
};
exports.AgentBuilderSettingsApp = AgentBuilderSettingsApp;