"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentLabels = void 0;
var _react = require("react");
var _use_agents = require("./use_agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentLabels = () => {
  const {
    agents,
    isLoading,
    error
  } = (0, _use_agents.useOnechatAgents)();
  const labels = (0, _react.useMemo)(() => {
    if (!agents || agents.length === 0) {
      return [];
    }

    // Extract all labels from all agents and create a unique set
    const allLabels = new Set();
    agents.forEach(agent => {
      if (agent.labels && Array.isArray(agent.labels)) {
        agent.labels.forEach(label => {
          allLabels.add(label.trim());
        });
      }
    });

    // Convert to array and sort alphabetically
    return Array.from(allLabels).sort((a, b) => a.toLowerCase().localeCompare(b.toLowerCase()));
  }, [agents]);
  return {
    labels,
    isLoading,
    error
  };
};
exports.useAgentLabels = useAgentLabels;