"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationCol = RelationCol;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _cell_value = require("../../../../components/alerts_table/common/cell_value");
var _paths = require("../../../../../common/locators/paths");
var _kibana_react = require("../../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/related_alerts/relation_col.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RelationCol({
  alert,
  parentAlert
}) {
  const {
    services: {
      http
    }
  } = (0, _kibana_react.useKibana)();
  const instanceId = (0, _cell_value.getAlertFieldValue)(alert, _ruleDataUtils.ALERT_INSTANCE_ID);
  const tags = (0, _cell_value.getAlertFieldValue)(alert, _ruleDataUtils.ALERT_RULE_TAGS);
  const ruleId = (0, _cell_value.getAlertFieldValue)(alert, _ruleDataUtils.ALERT_RULE_UUID);
  const ruleName = (0, _cell_value.getAlertFieldValue)(alert, _ruleDataUtils.ALERT_RULE_NAME);
  const ruleLink = ruleId ? http.basePath.prepend(_paths.paths.observability.ruleDetails(ruleId)) : '';
  const hasSomeRelationWithInstance = (0, _lodash.intersection)(parentAlert.fields[_ruleDataUtils.ALERT_INSTANCE_ID].split(','), instanceId.split(',')).length > 0;
  const hasSomeRelationWithTags = (0, _lodash.intersection)(parentAlert.fields[_ruleDataUtils.ALERT_RULE_TAGS], tags.split(',')).length > 0;
  const hasRelationWithRule = ruleId === parentAlert.fields[_ruleDataUtils.ALERT_RULE_UUID];
  const relations = [];
  if (hasSomeRelationWithInstance) {
    relations.push({
      title: _i18n.i18n.translate('xpack.observability.columns.groupsBadgeLabel', {
        defaultMessage: 'Groups'
      }),
      description: instanceId
    });
  }
  if (hasSomeRelationWithTags) {
    relations.push({
      title: _i18n.i18n.translate('xpack.observability.columns.tagsBadgeLabel', {
        defaultMessage: 'Tags'
      }),
      description: /*#__PURE__*/_react.default.createElement(_public.TagsList, {
        tags: alert[_ruleDataUtils.ALERT_RULE_TAGS] || [],
        ignoreEmpty: true,
        color: "default",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      })
    });
  }
  if (hasRelationWithRule) {
    relations.push({
      title: _i18n.i18n.translate('xpack.observability.columns.ruleBadgeLabel', {
        defaultMessage: 'Rule'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ruleLink,
        "data-test-subj": "obsAlertDetailsRelatedAlertsRelationRuleLink",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      }, ruleName)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: relations,
    css: {
      maxWidth: '400px'
    },
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
}