"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstallProductDoc = useInstallProductDoc;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useInstallProductDoc() {
  const {
    productDocBase,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.INSTALL_PRODUCT_DOC], inferenceId => {
    return productDocBase.installation.install({
      inferenceId
    });
  }, {
    networkMode: 'always',
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.installProductDoc.successNotification', {
        defaultMessage: 'The Elastic documentation was successfully installed'
      }));
      queryClient.invalidateQueries({
        queryKey: [_constants.REACT_QUERY_KEYS.GET_PRODUCT_DOC_STATUS],
        refetchType: 'all'
      });
    },
    onError: error => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.installProductDoc.errorNotification', {
          defaultMessage: 'Something went wrong while installing the Elastic documentation'
        })
      });
    }
  });
}