"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisContainer = RootCauseAnalysisContainer;
var _root_cause_analysis = require("@kbn/observability-ai-common/root_cause_analysis");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _inferenceCommon = require("@kbn/inference-common");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _entity_badge = require("../entity_badge");
var _rca_callout = require("../rca_callout");
var _rca_entity_investigation = require("../rca_entity_investigation");
var _rca_observation_panel = require("../rca_observation_panel");
var _rca_report = require("../rca_report");
var _rca_step = require("../rca_step");
var _rca_stop_button = require("../rca_stop_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/components/rca/rca_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RootCauseAnalysisContainer({
  events,
  completeInBackground,
  onStartAnalysisClick,
  onStopAnalysisClick,
  onResetAnalysisClick,
  onClearAnalysisClick,
  onCompleteInBackgroundClick,
  loading,
  error
}) {
  const theme = (0, _eui.useEuiTheme)();
  if (!(events !== null && events !== void 0 && events.length) && !loading && !error) {
    return /*#__PURE__*/_react.default.createElement(_rca_callout.RootCauseAnalysisCallout, {
      onClick: onStartAnalysisClick,
      completeInBackground: completeInBackground,
      onCompleteInBackgroundClick: onCompleteInBackgroundClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    });
  }
  const elements = [];
  const toolResponsesById = new Map(events === null || events === void 0 ? void 0 : events.filter(event => event.role === _inferenceCommon.MessageRole.Tool).map(event => [event.toolCallId, event]));
  events === null || events === void 0 ? void 0 : events.forEach(event => {
    if (event.role === _inferenceCommon.MessageRole.Assistant) {
      event.toolCalls.forEach(toolCall => {
        switch (toolCall.function.name) {
          case _root_cause_analysis.RCA_OBSERVE_TOOL_NAME:
            elements.push(getObservationItem(toolCall.function.arguments.title, toolResponsesById.get(toolCall.toolCallId)));
            break;
          case _root_cause_analysis.RCA_INVESTIGATE_ENTITY_TOOL_NAME:
          case _root_cause_analysis.RCA_END_PROCESS_TOOL_NAME:
            const response = toolResponsesById.get(toolCall.toolCallId);
            const element = response ? getToolResponseItem(response) : undefined;
            if (element) {
              elements.push(element);
            }
            break;
        }
      });
    }
  });
  const clearButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantAppRootCauseAnalysisClearButton",
    color: error ? 'danger' : 'primary',
    onClick: () => {
      onClearAnalysisClick();
    },
    iconType: "crossInCircle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.clearButtonLabel', {
    defaultMessage: 'Clear'
  }));
  const restartButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantAppRootCauseAnalysisRestartButton",
    color: error ? 'danger' : 'primary',
    fill: !!error,
    onClick: () => {
      onResetAnalysisClick();
    },
    iconType: "refresh",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.restartButtonLabel', {
    defaultMessage: 'Restart'
  }));
  if (loading) {
    const label = getLoadingLabel(events);
    elements.push(/*#__PURE__*/_react.default.createElement(_rca_step.RootCauseAnalysisStepItem, {
      label: label,
      button: completeInBackground ? undefined : /*#__PURE__*/_react.default.createElement(_rca_stop_button.RootCauseAnalysisStopButton, {
        onClick: () => {
          onStopAnalysisClick();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 13
        }
      }),
      loading: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 7
      }
    }));
  } else if (error) {
    elements.push(/*#__PURE__*/_react.default.createElement(_rca_step.RootCauseAnalysisStepItem, {
      label: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.analysisError', {
        defaultMessage: 'Failed to complete analysis: {errorMessage}',
        values: {
          errorMessage: error.message
        }
      }),
      iconType: "alert",
      color: "danger",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 11
        }
      }, clearButton, restartButton),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    }));
  } else {
    // completed
    elements.push(/*#__PURE__*/_react.default.createElement(_rca_step.RootCauseAnalysisStepItem, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m",
        className: (0, _css.css)`
              font-weight: ${theme.euiTheme.font.weight.bold};
            `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.analysisCompleted', {
        defaultMessage: 'Completed analysis'
      })),
      iconType: "checkInCircleFilled",
      color: "primary",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 11
        }
      }, clearButton, restartButton),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 5
    }
  }, elements.map((element, index) => {
    return /*#__PURE__*/_react.default.cloneElement(element, {
      key: index
    });
  }));
}
function getLoadingLabel(events) {
  const lastAssistantMessage = (0, _lodash.findLast)(events, event => event.role === _inferenceCommon.MessageRole.Assistant);
  if (lastAssistantMessage) {
    var _pendingToolCalls$;
    const toolResponsesByToolCallId = new Map(events === null || events === void 0 ? void 0 : events.filter(event => event.role === _inferenceCommon.MessageRole.Tool).map(event => [event.toolCallId, event]));
    const pendingToolCalls = lastAssistantMessage.toolCalls.filter(event => {
      const response = toolResponsesByToolCallId.get(event.toolCallId);
      return !response;
    });
    const allInvestigateEntityToolCalls = pendingToolCalls.filter(event => event.function.name === _root_cause_analysis.RCA_INVESTIGATE_ENTITY_TOOL_NAME);
    if (allInvestigateEntityToolCalls.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "m",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.investigatingEntitiesTextLabel', {
        defaultMessage: 'Investigating entities'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 13
        }
      }, allInvestigateEntityToolCalls.map(toolCall => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          key: toolCall.toolCallId,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_entity_badge.EntityBadge, {
          entity: {
            [toolCall.function.arguments.entity.field]: toolCall.function.arguments.entity.value
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 247,
            columnNumber: 21
          }
        }));
      }))));
    }
    if (((_pendingToolCalls$ = pendingToolCalls[0]) === null || _pendingToolCalls$ === void 0 ? void 0 : _pendingToolCalls$.function.name) === _root_cause_analysis.RCA_END_PROCESS_TOOL_NAME) {
      return _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.finalizingReport', {
        defaultMessage: 'Finalizing report'
      });
    }
  }
  return _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.analysisLoadingLabel', {
    defaultMessage: 'Thinking...'
  });
}
function getToolResponseErrorItem(response) {
  return /*#__PURE__*/_react.default.createElement(_rca_step.RootCauseAnalysisStepItem, {
    label: _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.toolResponseError', {
      defaultMessage: 'Failed to execute task: {errorMessage}',
      values: {
        errorMessage: response.error.message
      }
    }),
    iconType: "alert",
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 5
    }
  });
}
function getToolResponseItem(message) {
  if (message.name === 'observe') {
    return null;
  }
  if (message.name === 'error') {
    return getToolResponseErrorItem(message.response);
  }
  if (message.name === 'investigateEntity') {
    return /*#__PURE__*/_react.default.createElement(_rca_entity_investigation.RootCauseAnalysisEntityInvestigation, {
      summary: message.response.summary,
      entity: message.response.entity,
      ownPatterns: message.data.attachments.ownPatterns,
      patternsFromOtherEntities: message.data.attachments.patternsFromOtherEntities,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_rca_report.RootCauseAnalysisReport, {
    report: message.response.report,
    timeline: message.response.timeline,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 5
    }
  });
}
function getObservationItem(title, toolResponse) {
  let content;
  switch (toolResponse === null || toolResponse === void 0 ? void 0 : toolResponse.name) {
    case 'observe':
      content = toolResponse.response.content;
      break;
    case 'error':
      content = _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.failedObservation', {
        defaultMessage: 'Failed to generate observations'
      });
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_rca_observation_panel.RootCauseAnalysisObservationPanel, {
    title: title,
    content: content,
    loading: !toolResponse,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 5
    }
  });
}