"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metric = Metric;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_viewer/views/metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const metricStyle = type => ({
  euiTheme
}) => {
  let width;
  switch (type) {
    case 'cpuTime':
      width = euiTheme.size.xxl;
      break;
    case 'events':
    case 'eventsEmitted':
      width = `calc(${euiTheme.size.xxl} * 4)`;
      break;
    case 'eventMillis':
      width = `calc(${euiTheme.size.xxl} * 2)`;
      break;
    default:
      width = 'auto';
  }
  return (0, _react2.css)`
      text-align: right;
      width: ${width};

      @media (min-width: ${euiTheme.breakpoint.m}) {
        text-align: left;
        ${(0, _eui.logicalCSS)('padding-left', euiTheme.size.xl)}
      }
    `;
};
const metricFlexItemStyle = ({
  euiTheme
}) => (0, _react2.css)`
  @media (min-width: ${euiTheme.breakpoint.m}) {
    ${(0, _eui.logicalCSS)('margin-bottom', euiTheme.size.xs)}
  }
`;
function Metric({
  type,
  warning,
  value
}) {
  let stylizedValue;
  if (warning) {
    stylizedValue = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 21
      }
    }, value);
  } else {
    stylizedValue = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: metricStyle(type),
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, value));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: metricFlexItemStyle,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, stylizedValue);
}