"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enabledSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  enabled: _configSchema.schema.boolean()
}));
const compatibleModuleTypeSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('observability'), _configSchema.schema.literal('security'), _configSchema.schema.literal('search')]));
const vCPURangeSchema = _configSchema.schema.object({
  min: _configSchema.schema.number(),
  max: _configSchema.schema.number(),
  static: _configSchema.schema.maybe(_configSchema.schema.number()),
  maxThreads: _configSchema.schema.number()
});
const configSchema = exports.configSchema = _configSchema.schema.object({
  ad: enabledSchema,
  dfa: enabledSchema,
  nlp: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.boolean(),
    modelDeployment: _configSchema.schema.maybe(_configSchema.schema.object({
      allowStaticAllocations: _configSchema.schema.boolean(),
      vCPURange: _configSchema.schema.object({
        low: vCPURangeSchema,
        medium: vCPURangeSchema,
        high: vCPURangeSchema
      })
    }))
  })),
  compatibleModuleType: compatibleModuleTypeSchema,
  experimental: _configSchema.schema.maybe(_configSchema.schema.object({
    ruleFormV2: enabledSchema
  }))
});