"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserInputModelDeploymentParamsProvider = exports.StartUpdateDeploymentModal = exports.DeploymentSetup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _mlValidators = require("@kbn/ml-validators");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _trained_models = require("../../../common/types/trained_models");
var _ml_server_info = require("../services/ml_server_info");
var _deployment_params_mapper = require("./deployment_params_mapper");
var _model_status_indicator = require("./model_status_indicator");
var _kibana = require("../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/deployment_setup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Interface for deployment params in the UI.
 */

const sliderPalette = (0, _eui.euiPaletteCool)(3);

/**
 * Dict for vCPU levels.
 */
const vCpuLevelMap = {
  low: {
    value: 0.5,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.lowCpuLabel', {
      defaultMessage: 'Low'
    }),
    color: sliderPalette[0]
  },
  medium: {
    value: 1.5,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.mediumCpuLabel', {
      defaultMessage: 'Medium'
    }),
    color: sliderPalette[1]
  },
  high: {
    value: 2.5,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.highCpuLabel', {
      defaultMessage: 'High'
    }),
    color: sliderPalette[2]
  }
};

/**
 * Form for setting threading params.
 */
const DeploymentSetup = ({
  config,
  onConfigChange,
  errors,
  isUpdate,
  deploymentsParams,
  disableAdaptiveResourcesControl,
  deploymentParamsMapper,
  cloudInfo,
  showNodeInfo
}) => {
  var _config$deploymentId;
  const deploymentIdUpdated = (0, _react.useRef)(false);
  const defaultDeploymentId = (0, _react.useMemo)(() => {
    return config.deploymentId;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const customTicks = (0, _react.useMemo)(() => Object.values(vCpuLevelMap).map(v => {
    return {
      label: v.label,
      value: v.value
    };
  }), []);
  const customColorsLevels = (0, _react.useMemo)(() => [{
    min: 0.5,
    max: 1.1,
    color: vCpuLevelMap.low.color
  }, {
    min: 1.1,
    max: 1.9,
    color: vCpuLevelMap.medium.color
  }, {
    min: 1.9,
    max: 2.5,
    color: vCpuLevelMap.high.color
  }], []);
  const optimizedOptions = (0, _react.useMemo)(() => [{
    id: 'optimizedForIngest',
    value: 'optimizedForIngest',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.optimizedForIngestLabel",
      defaultMessage: "Ingest",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.optimizedForIngestDescription",
      defaultMessage: "Optimized for higher throughput during ingest",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 11
      }
    }),
    'data-test-subj': `mlModelsStartDeploymentModalOptimizedForIngest`
  }, {
    id: 'optimizedForSearch',
    value: 'optimizedForSearch',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.optimizedForSearchLabel",
      defaultMessage: "Search",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.optimizedForSearchDescription",
      defaultMessage: "Optimized for lower latency during search",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 11
      }
    }),
    'data-test-subj': `mlModelsStartDeploymentModalOptimizedForSearch`
  }], []);
  const helperText = (0, _react.useMemo)(() => {
    const vcpuRange = deploymentParamsMapper.getVCPURange(config.vCPUUsage);
    if (cloudInfo.isCloud && cloudInfo.isMlAutoscalingEnabled && showNodeInfo) {
      // Running in cloud with ML autoscaling enabled
      if (config.adaptiveResources) {
        // With adaptive resources
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.lowCpuAdaptiveHelp', {
              defaultMessage: 'This level limits resources to the minimum required for the model to run if supported by your Cloud console selection. It may not be sufficient for a production application.'
            });
          case 'medium':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.mediumCpuAdaptiveHelp', {
              defaultMessage: 'Your model will scale up to a maximum of {maxVCPUs} vCPUs. Even if the Cloud console provides more, the model will not exceed {maxVCPUs}, leaving additional resources for other models.',
              values: {
                maxVCPUs: vcpuRange.max
              }
            });
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.highCpuAdaptiveHelp', {
              defaultMessage: 'Your model may scale up to the maximum number of vCPUs available for this deployment from the Cloud console if needed. If the maximum is {minVCPUs} vCPUs or fewer, this level is equivalent to the medium level.',
              // use an upper bound of medium level
              values: {
                minVCPUs: vcpuRange.min - 1
              }
            });
        }
      } else {
        // Without adaptive resources
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.lowCpuStaticHelp', {
              defaultMessage: 'This level sets resources to the minimum required for the model to run if supported by your Cloud console selection. It may not be sufficient for a production application.'
            });
          case 'medium':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.mediumCpuStaticHelp', {
              defaultMessage: 'Your model will consume {staticVCPUs} vCPUs, even when not in use, if provided by the Cloud console.',
              values: {
                staticVCPUs: vcpuRange.static
              }
            });
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.cloudAutoscaling.highCpuStaticHelp', {
              defaultMessage: 'Your model will consume {staticVCPUs} vCPUs, even when not in use, if provided by the Cloud console.',
              values: {
                staticVCPUs: vcpuRange.static
              }
            });
        }
      }
    } else if (cloudInfo.isCloud && !cloudInfo.isMlAutoscalingEnabled && showNodeInfo || !cloudInfo.isCloud && showNodeInfo) {
      // Running in cloud with autoscaling disabled or on-prem
      if (config.adaptiveResources) {
        // With adaptive resources
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.lowCpuAdaptiveHelp', {
              defaultMessage: 'This level limits resources to {maxVCPUs, plural, one {vCPU} other {# vCPUs}}, which may be suitable for development, testing, and demos depending on your parameters. It is not recommended for production use.',
              values: {
                maxVCPUs: vcpuRange.max
              }
            });
          case 'medium':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.mediumCpuAdaptiveHelp', {
              defaultMessage: 'This level limits resources to {maxVCPUs, plural, one {vCPU} other {# vCPUs}}, which may be suitable for development, testing, and demos depending on your parameters. It is not recommended for production use.',
              values: {
                maxVCPUs: vcpuRange.max
              }
            });
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.highCpuAdaptiveHelp', {
              defaultMessage: 'This level may use {maxVCPUs, plural, one {vCPU} other {# vCPUs}} - the maximum number of vCPUs available for this deployment. If the maximum is 2 vCPUs or fewer, this level is equivalent to the medium or low level.',
              values: {
                maxVCPUs: vcpuRange.max
              }
            });
        }
      } else {
        // Without adaptive resources
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.lowCpuStaticHelp', {
              defaultMessage: 'This level sets resources to the minimum required for the model to run. It may not be sufficient for a production application.'
            });
          case 'medium':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.mediumCpuStaticHelp', {
              defaultMessage: 'Your model will consume {staticVCPUs} vCPUs, even when not in use.',
              values: {
                staticVCPUs: vcpuRange.static
              }
            });
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.hardwareLimits.highCpuStaticHelp', {
              defaultMessage: 'Your model will consume {staticVCPUs} vCPUs - the maximum available number.',
              values: {
                staticVCPUs: vcpuRange.static
              }
            });
        }
      }
    } else if (!showNodeInfo) {
      // Running in serverless
      const vcuRange = deploymentParamsMapper.getVCURange(config.vCPUUsage);
      if (config.adaptiveResources) {
        // With adaptive resources
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.serverless.lowCpuAdaptiveHelp', {
              defaultMessage: 'This level limits resources to {vcus, plural, one {VCU} other {# VCUs}}, which may be suitable for development, testing, and demos depending on your parameters. It is not recommended for production use.',
              values: {
                vcus: vcuRange.max
              }
            });
          case 'medium':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.serverless.mediumCpuAdaptiveHelp', {
              defaultMessage: 'Your model will scale up to a maximum of {vcus, plural, one {VCU} other {# VCUs}} per hour based on your search or ingest load. It will automatically scale down when demand decreases, and you only pay for the resources you use.',
              values: {
                vcus: vcuRange.max
              }
            });
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.serverless.highCpuAdaptiveHelp', {
              defaultMessage: 'Your model will scale up to a maximum of {vcus, plural, one {VCU} other {# VCUs}} per hour based on your search or ingest load. It will automatically scale down when demand decreases, and you only pay for the resources you use.',
              values: {
                vcus: vcuRange.max
              }
            });
        }
      } else {
        // Static allocations are allowed for Search projects
        switch (config.vCPUUsage) {
          case 'low':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.serverless.lowCpuStaticHelp', {
              defaultMessage: 'This level set resources to {staticVCUs, plural, one {VCU} other {# VCUs}}, which may be suitable for development, testing, and demos depending on your parameters. It is not recommended for production use.',
              values: {
                staticVCUs: vcuRange.static
              }
            });
          case 'medium':
          case 'high':
            return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.serverless.mediumCpuStaticHelp', {
              defaultMessage: 'Your model will consume {staticVCUs, plural, one {VCU} other {# VCUs}}, even when not in use.',
              values: {
                staticVCUs: vcuRange.static
              }
            });
        }
      }
    }
  }, [cloudInfo.isCloud, cloudInfo.isMlAutoscalingEnabled, config.adaptiveResources, config.vCPUUsage, deploymentParamsMapper, showNodeInfo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: 'form',
    id: 'startDeploymentForm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.deploymentIdLabel",
      defaultMessage: "Deployment ID",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 443,
        columnNumber: 11
      }
    }),
    hasChildLabel: false,
    isInvalid: !!errors.deploymentId,
    error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.deploymentIdError",
      defaultMessage: "Deployment with this ID already exists.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 7
    }
  }, !isUpdate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    placeholder: defaultDeploymentId,
    isInvalid: !!errors.deploymentId,
    value: (_config$deploymentId = config.deploymentId) !== null && _config$deploymentId !== void 0 ? _config$deploymentId : '',
    onChange: e => {
      deploymentIdUpdated.current = true;
      onConfigChange({
        ...config,
        deploymentId: e.target.value
      });
    },
    "data-test-subj": 'mlModelsStartDeploymentModalDeploymentId',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: Object.keys(deploymentsParams).map(v => {
      return {
        text: v,
        value: v
      };
    }),
    value: config.deploymentId,
    onChange: e => {
      const update = e.target.value;
      const targetDeployment = deploymentsParams[update];
      onConfigChange({
        ...targetDeployment
      });
    },
    "data-test-subj": 'mlModelsStartDeploymentModalDeploymentSelectId',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: true,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 490,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.startDeployment.optimizeThreadsPerAllocationLabel",
        defaultMessage: "Optimize this model deployment for your use case:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 494,
          columnNumber: 15
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 9
    }
  }, optimizedOptions.map(v => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: v.value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 503,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
      id: v.value,
      disabled: isUpdate,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 508,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'baseline',
        gutterSize: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 509,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 510,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 511,
          columnNumber: 27
        }
      }, v.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 513,
          columnNumber: 25
        }
      }, v.description))),
      value: v.value,
      checked: config.optimized === v.value,
      onChange: () => {
        var _config$deploymentId2;
        onConfigChange({
          ...config,
          ...(deploymentIdUpdated.current ? {} : {
            // rename deployment ID based on the optimized value
            deploymentId: (_config$deploymentId2 = config.deploymentId) === null || _config$deploymentId2 === void 0 ? void 0 : _config$deploymentId2.replace(/_[a-zA-Z]+$/, v.value === 'optimizedForIngest' ? '_ingest' : '_search')
          }),
          optimized: v.value
        });
      },
      "data-test-subj": `mlModelsStartDeploymentModalOptimized_${v.value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 504,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 536,
        columnNumber: 17
      }
    }));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'modelDeploymentAdvancedSettings',
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.advancedSettingsLabel",
      defaultMessage: "Advanced configurations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 546,
        columnNumber: 11
      }
    }),
    initialIsOpen: isUpdate,
    "data-test-subj": 'mlModelsStartDeploymentModalAdvancedConfiguration',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 543,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 554,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false,
    fullWidth: true,
    label: showNodeInfo ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.vCpuUsageLabel",
      defaultMessage: "vCPUs usage level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 562,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.vCUUsageLabel",
      defaultMessage: "VCU usage level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 567,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    fullWidth: true,
    id: 'vCpuLevel',
    min: 0.5,
    max: 2.5,
    step: 1,
    tickInterval: 1,
    value: vCpuLevelMap[config.vCPUUsage].value,
    onChange: e => {
      const result = Object.entries(vCpuLevelMap).find(([, val]) => val.value === Number(e.currentTarget.value));
      onConfigChange({
        ...config,
        vCPUUsage: result[0]
      });
    },
    showTicks: true,
    ticks: customTicks,
    levels: customColorsLevels,
    "aria-label": showNodeInfo ? _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.vCpuLevel', {
      defaultMessage: 'vCPUs level selector'
    }) : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.startDeployment.vCULevel', {
      defaultMessage: 'VCUs level selector'
    }),
    "aria-describedby": 'vCpuRangeHelp',
    "data-test-subj": 'mlModelsStartDeploymentModalVCPULevel',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 574,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    id: 'vCpuRangeHelp',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    "data-test-subj": "mlModelsStartDeploymentModalVCPUHelperText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 13
    }
  }, helperText))), !disableAdaptiveResourcesControl ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 619,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.startDeployment.adaptiveAllocationEnabledLabel",
      defaultMessage: "Adaptive resources (recommended)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 623,
        columnNumber: 17
      }
    }),
    checked: !!config.adaptiveResources,
    onChange: event => {
      onConfigChange({
        ...config,
        adaptiveResources: event.target.checked
      });
    },
    "aria-describedby": 'adaptiveResourcesHelp',
    "data-test-subj": 'mlModelsStartDeploymentModalAdaptiveResources',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 621,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 639,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    id: 'adaptiveResourcesHelp',
    "data-test-subj": 'mlModelsStartDeploymentModalVCPULevelHelpText',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 641,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: 'xpack.ml.trainedModels.modelsList.startDeployment.adaptiveResourcesHelp',
    defaultMessage: 'Adjust resources to optimize for load and savings. If disabled, the deployments will not auto-scale.',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 645,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 653,
      columnNumber: 13
    }
  })) : null));
};
exports.DeploymentSetup = DeploymentSetup;
/**
 * Modal window wrapper for {@link DeploymentSetup}
 */
const StartUpdateDeploymentModal = ({
  modelId,
  onConfigChange,
  onClose,
  startModelDeploymentDocUrl,
  initialParams,
  modelAndDeploymentIds,
  cloudInfo,
  deploymentParamsMapper,
  showNodeInfo,
  nlpSettings
}) => {
  var _config$deploymentId3, _nlpSettings$modelDep, _model$stats2;
  const {
    services: {
      mlServices: {
        trainedModelsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const model = (0, _useObservable.default)(trainedModelsService.getModel$(modelId), trainedModelsService.getModel(modelId));
  const isUpdate = !!initialParams;
  const isModelNotDownloaded = model ? (0, _trained_models.isModelDownloadItem)(model) : true;
  const getDefaultParams = (0, _react.useCallback)(() => {
    var _model$stats;
    const defaultVCPUUsage = showNodeInfo ? 'medium' : 'low';
    const defaultParams = {
      deploymentId: `${modelId}_ingest`,
      optimized: 'optimizedForIngest',
      vCPUUsage: defaultVCPUUsage,
      adaptiveResources: true
    };
    if (isModelNotDownloaded) {
      return defaultParams;
    }
    const uiParams = (0, _trained_models.isNLPModelItem)(model) ? model === null || model === void 0 ? void 0 : (_model$stats = model.stats) === null || _model$stats === void 0 ? void 0 : _model$stats.deployment_stats.map(v => deploymentParamsMapper.mapApiToUiDeploymentParams(v)) : [];
    return uiParams !== null && uiParams !== void 0 && uiParams.some(v => v.optimized === 'optimizedForIngest') ? {
      deploymentId: `${modelId}_search`,
      optimized: 'optimizedForSearch',
      vCPUUsage: defaultVCPUUsage,
      adaptiveResources: true
    } : defaultParams;
  }, [deploymentParamsMapper, isModelNotDownloaded, model, modelId, showNodeInfo]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [config, setConfig] = (0, _react.useState)(initialParams !== null && initialParams !== void 0 ? initialParams : getDefaultParams());
  const deploymentIdValidator = (0, _react.useMemo)(() => {
    if (isUpdate || !(0, _trained_models.isNLPModelItem)(model)) {
      return () => null;
    }
    const otherModelAndDeploymentIds = [...(modelAndDeploymentIds !== null && modelAndDeploymentIds !== void 0 ? modelAndDeploymentIds : [])];
    otherModelAndDeploymentIds.splice(otherModelAndDeploymentIds === null || otherModelAndDeploymentIds === void 0 ? void 0 : otherModelAndDeploymentIds.indexOf(modelId), 1);
    return (0, _mlValidators.dictionaryValidator)([...model.deployment_ids, ...otherModelAndDeploymentIds,
    // check for deployment with the default ID
    ...(model.deployment_ids.includes(model.model_id) ? [''] : [])]);
  }, [isUpdate, model, modelAndDeploymentIds, modelId]);
  const deploymentIdErrors = deploymentIdValidator((_config$deploymentId3 = config.deploymentId) !== null && _config$deploymentId3 !== void 0 ? _config$deploymentId3 : '');
  const errors = {
    ...(deploymentIdErrors ? {
      deploymentId: deploymentIdErrors
    } : {})
  };
  const modelStatusIndicatorConfigOverrides = {
    names: {
      downloading: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadingModelName', {
        defaultMessage: 'Downloading model'
      })
    },
    color: euiTheme.colors.textSubdued
  };
  const showModelStatusIndicator = (0, _trained_models.isNLPModelItem)(model) && ((model === null || model === void 0 ? void 0 : model.state) === _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING || (model === null || model === void 0 ? void 0 : model.state) === _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    "data-test-subj": "mlModelsStartDeploymentModal",
    maxWidth: 640,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 779,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    css: {
      paddingInline: `${euiTheme.size.l} 0px`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 786,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 787,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      paddingInline: `0px ${euiTheme.size.xxl}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 788,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 789,
      columnNumber: 13
    }
  }, isUpdate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.updateDeployment.modalTitle",
    defaultMessage: "Update {modelId} deployment",
    values: {
      modelId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 791,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.modalTitle",
    defaultMessage: "Start {modelId} deployment",
    values: {
      modelId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 797,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      paddingInline: `0px ${euiTheme.size.l}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 805,
      columnNumber: 11
    }
  }, showModelStatusIndicator && /*#__PURE__*/_react.default.createElement(_model_status_indicator.ModelStatusIndicator, {
    modelId: model.model_id,
    configOverrides: modelStatusIndicatorConfigOverrides,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 807,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      paddingInline: `0px ${euiTheme.size.l}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 813,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 814,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 819,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(DeploymentSetup, {
    deploymentParamsMapper: deploymentParamsMapper,
    cloudInfo: cloudInfo,
    showNodeInfo: showNodeInfo,
    config: config,
    onConfigChange: setConfig,
    errors: errors,
    isUpdate: isUpdate,
    disableAdaptiveResourcesControl: !showNodeInfo || ((_nlpSettings$modelDep = nlpSettings.modelDeployment) === null || _nlpSettings$modelDep === void 0 ? void 0 : _nlpSettings$modelDep.allowStaticAllocations) === false,
    deploymentsParams: isModelNotDownloaded || !(0, _trained_models.isNLPModelItem)(model) ? {} : (_model$stats2 = model.stats) === null || _model$stats2 === void 0 ? void 0 : _model$stats2.deployment_stats.reduce((acc, curr) => {
      acc[curr.deployment_id] = deploymentParamsMapper.mapApiToUiDeploymentParams(curr);
      return acc;
    }, {}),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 820,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 845,
      columnNumber: 9
    }
  }), cloudInfo.cloudUrl && showNodeInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.adaptiveResourcesCloudHelp",
    defaultMessage: "Autoscaling uses the base vCPU values from Cloud Console when determining the size to meet the usage needs.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 849,
      columnNumber: 13
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: cloudInfo.cloudUrl,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 854,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.cloudConsoleLink",
    defaultMessage: "Go to cloud console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 855,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 860,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 865,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: startModelDeploymentDocUrl,
    external: true,
    target: '_blank',
    css: (0, _react2.css)`
            align-self: center;
            margin-right: auto;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 866,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.docLinkTitle",
    defaultMessage: "Learn more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 875,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 881,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 882,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    form: 'startDeploymentForm',
    onClick: onConfigChange.bind(null, config),
    fill: true,
    disabled: Object.keys(errors).length > 0,
    "data-test-subj": 'mlModelsStartDeploymentModalStartButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 888,
      columnNumber: 9
    }
  }, isUpdate ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.updateButton",
    defaultMessage: "Update",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 897,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.startDeployment.startButton",
    defaultMessage: "Start",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 902,
      columnNumber: 13
    }
  }))));
};

/**
 * Returns a callback for requesting user's input for threading params
 * with a form rendered in a modal window.
 *
 * @param overlays
 * @param theme$
 */
exports.StartUpdateDeploymentModal = StartUpdateDeploymentModal;
const getUserInputModelDeploymentParamsProvider = (overlays, startServices, startModelDeploymentDocUrl, cloudInfo, showNodeInfo, nlpSettings, httpService, trainedModelsService, mlCapabilities) => (modelId, initialParams, deploymentIds) => {
  const deploymentParamsMapper = new _deployment_params_mapper.DeploymentParamsMapper((0, _ml_server_info.getNewJobLimits)(), cloudInfo, nlpSettings);
  const params = initialParams ? deploymentParamsMapper.mapApiToUiDeploymentParams(initialParams) : undefined;
  return new Promise(async resolve => {
    try {
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          mlServices: {
            httpService,
            trainedModelsService,
            mlCapabilities
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 951,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(StartUpdateDeploymentModal, {
        nlpSettings: nlpSettings,
        showNodeInfo: showNodeInfo,
        deploymentParamsMapper: deploymentParamsMapper,
        cloudInfo: cloudInfo,
        startModelDeploymentDocUrl: startModelDeploymentDocUrl,
        initialParams: params,
        modelAndDeploymentIds: deploymentIds,
        modelId: modelId,
        onConfigChange: config => {
          modalSession.close();
          resolve(config);
        },
        onClose: () => {
          modalSession.close();
          resolve();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 954,
          columnNumber: 15
        }
      })), startServices));
    } catch (e) {
      resolve();
    }
  });
};
exports.getUserInputModelDeploymentParamsProvider = getUserInputModelDeploymentParamsProvider;