"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _app = require("../../../../../../../common/constants/app");
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _ml = require("../../../../../contexts/ml");
var _event_rate_chart = require("../charts/event_rate_chart");
var _new_job = require("../../../../../../../common/constants/new_job");
var _components = require("../../../common/components");
var _kibana = require("../../../../../contexts/kibana");
var _storage = require("../../../../../../../common/types/storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/time_range_step/time_range.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeRangeStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const dataSourceContext = (0, _ml.useDataSource)();
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    chartLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: jobCreator.start,
    end: jobCreator.end
  });
  const [eventRateChartData, setEventRateChartData] = (0, _react.useState)([]);
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.ML_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  async function loadChart() {
    setLoadingData(true);
    try {
      var _jobCreator$runtimeMa;
      const resp = await chartLoader.loadEventRateChart(jobCreator.start, jobCreator.end, chartInterval.getInterval().asMilliseconds(), (_jobCreator$runtimeMa = jobCreator.runtimeMappings) !== null && _jobCreator$runtimeMa !== void 0 ? _jobCreator$runtimeMa : undefined, jobCreator.datafeedConfig.indices_options);
      setEventRateChartData(resp);
    } catch (error) {
      setEventRateChartData([]);
    }
    setLoadingData(false);
  }
  (0, _react.useEffect)(() => {
    const {
      start,
      end
    } = timeRange;
    jobCreator.setTimeRange(start, end);
    chartInterval.setBounds({
      min: (0, _moment.default)(start),
      max: (0, _moment.default)(end)
    });
    // update the timefilter, to keep the URL in sync
    const {
      timefilter: timefilterService
    } = services.data.query.timefilter;
    timefilterService.setTime({
      from: (0, _moment.default)(start).toISOString(),
      to: (0, _moment.default)(end).toISOString()
    });
    jobCreatorUpdate();
    loadChart();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, chartInterval, timeRange.start, timeRange.end, jobCreatorUpdate, services.data.query.timefilter]);
  (0, _react.useEffect)(() => {
    setTimeRange({
      start: jobCreator.start,
      end: jobCreator.end
    });
  }, [jobCreator, jobCreatorUpdated]);
  function fullTimeRangeCallback(range) {
    if (range.start !== null && range.end !== null) {
      setTimeRange({
        start: range.start.epoch,
        end: range.end.epoch
      });
    } else {
      const {
        toasts
      } = services.notifications;
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.fullTimeRangeError', {
        defaultMessage: 'An error occurred obtaining the time range for the index. Please set the desired start and end times.'
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.TimeRangePicker, {
    setTimeRange: setTimeRange,
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
    frozenDataPreference: frozenDataPreference,
    setFrozenDataPreference: setFrozenDataPreference,
    dataView: dataSourceContext.selectedDataView,
    query: dataSourceContext.combinedQuery,
    disabled: false,
    callback: fullTimeRangeCallback,
    timefilter: timefilter,
    apiPath: `${_app.ML_INTERNAL_BASE_PATH}/fields_service/time_field_range`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateChartData,
    height: "300px",
    width: "100%",
    showAxis: true,
    loading: loadingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    next: () => setCurrentStep(jobCreator.type === _new_job.JOB_TYPE.ADVANCED ? _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED : _step_types.WIZARD_STEPS.PICK_FIELDS),
    nextActive: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })));
};
exports.TimeRangeStep = TimeRangeStep;