"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyExplorerContextProvider = exports.AnomalyExplorerContext = void 0;
exports.useAnomalyExplorerContext = useAnomalyExplorerContext;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _url_state = require("@kbn/ml-url-state/src/url_state");
var _anomaly_timeline_state_service = require("./anomaly_timeline_state_service");
var _anomaly_explorer_common_state = require("./anomaly_explorer_common_state");
var _kibana = require("../contexts/kibana");
var _results_service = require("../services/results_service");
var _anomaly_timeline_service = require("../services/anomaly_timeline_service");
var _use_explorer_url_state = require("./hooks/use_explorer_url_state");
var _anomaly_charts_state_service = require("./anomaly_charts_state_service");
var _anomaly_explorer_charts_service = require("../services/anomaly_explorer_charts_service");
var _select_severity = require("../components/controls/select_severity");
var _alerts = require("./alerts");
var _job_service = require("../services/job_service");
var _select_interval = require("../components/controls/select_interval");
var _anomaly_table_state_service = require("./anomaly_table_state_service");
var _annotations_state_service = require("./annotations_state_service");
var _influencers_state_service = require("./influencers_state_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/anomaly_explorer_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Context of the Anomaly Explorer page.
 */
const AnomalyExplorerContext = exports.AnomalyExplorerContext = /*#__PURE__*/_react.default.createContext(undefined);

/**
 * Hook for consuming {@link AnomalyExplorerContext}.
 */
function useAnomalyExplorerContext() {
  const context = (0, _react.useContext)(AnomalyExplorerContext);
  if (context === undefined) {
    throw new Error('AnomalyExplorerContext has not been initialized.');
  }
  return context;
}

/**
 * Anomaly Explorer Context Provider.
 */
const AnomalyExplorerContextProvider = ({
  children
}) => {
  const [,, anomalyExplorerUrlStateService] = (0, _use_explorer_url_state.useExplorerUrlState)();
  const [,, globalUrlStateService] = (0, _url_state.useGlobalUrlState)();
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    services: {
      mlServices: {
        mlApi
      },
      uiSettings,
      data
    }
  } = (0, _kibana.useMlKibana)();
  const mlJobService = (0, _job_service.useMlJobService)();
  const [,, tableSeverityUrlStateService] = (0, _select_severity.useTableSeverity)();
  const [,, tableIntervalUrlStateService] = (0, _select_interval.useTableInterval)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const mlResultsService = (0, _react.useMemo)(() => (0, _results_service.mlResultsServiceProvider)(mlApi), []);
  const [anomalyExplorerContextValue, setAnomalyExplorerContextValue] = (0, _react.useState)(undefined);

  // It might look tempting to refactor this into `useMemo()` and just return
  // `anomalyExplorerContextValue`, but these services internally might call other state
  // updates so using `useEffect` is the right thing to do here to not get errors
  // related to React lifecycle methods.
  (0, _react.useEffect)(() => {
    const anomalyTimelineService = new _anomaly_timeline_service.AnomalyTimelineService(timefilter, uiSettings, mlApi);
    const anomalyExplorerCommonStateService = new _anomaly_explorer_common_state.AnomalyExplorerCommonStateService(anomalyExplorerUrlStateService, globalUrlStateService, mlJobService);
    const anomalyTimelineStateService = new _anomaly_timeline_state_service.AnomalyTimelineStateService(mlJobService, anomalyExplorerUrlStateService, anomalyExplorerCommonStateService, anomalyTimelineService, timefilter);
    const anomalyExplorerChartsService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(timefilter, mlApi, mlResultsService);
    const chartsStateService = new _anomaly_charts_state_service.AnomalyChartsStateService(anomalyExplorerCommonStateService, anomalyTimelineStateService, anomalyExplorerChartsService, anomalyExplorerUrlStateService, tableSeverityUrlStateService);
    const anomalyDetectionAlertsStateService = new _alerts.AnomalyDetectionAlertsStateService(anomalyTimelineStateService, data, timefilter);
    const anomalyTableService = new _anomaly_table_state_service.AnomalyTableStateService(mlApi, mlJobService, uiSettings, timefilter, anomalyExplorerCommonStateService, anomalyTimelineStateService, tableSeverityUrlStateService, tableIntervalUrlStateService);
    const annotationsStateService = new _annotations_state_service.AnnotationsStateService(mlApi, timefilter, anomalyExplorerCommonStateService, anomalyTimelineStateService);
    const influencersStateService = new _influencers_state_service.InfluencersStateService(mlApi, timefilter, anomalyExplorerCommonStateService, anomalyTimelineStateService);
    setAnomalyExplorerContextValue({
      anomalyExplorerChartsService,
      anomalyExplorerCommonStateService,
      anomalyTimelineService,
      anomalyTimelineStateService,
      chartsStateService,
      anomalyDetectionAlertsStateService,
      anomalyTableService,
      annotationsStateService,
      influencersStateService
    });
    return () => {
      // upon component unmounting
      // clear any data to prevent next page from rendering old charts
      anomalyExplorerCommonStateService.destroy();
      anomalyTimelineStateService.destroy();
      chartsStateService.destroy();
      anomalyDetectionAlertsStateService.destroy();
      anomalyTableService.destroy();
      annotationsStateService.destroy();
      influencersStateService.destroy();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (anomalyExplorerContextValue === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(AnomalyExplorerContext.Provider, {
    value: anomalyExplorerContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, children);
};
exports.AnomalyExplorerContextProvider = AnomalyExplorerContextProvider;