"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorerData = exports.isLoadExplorerDataConfig = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _react = require("react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _explorer_utils = require("../explorer_utils");
var _kibana = require("../../contexts/kibana");
var _results_service = require("../../services/results_service");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isLoadExplorerDataConfig = arg => {
  return arg !== undefined && arg.selectedJobs !== undefined && arg.selectedJobs !== null && arg.viewBySwimlaneFieldName !== undefined;
};

/**
 * Fetches the data necessary for the Anomaly Explorer using observables.
 */
exports.isLoadExplorerDataConfig = isLoadExplorerDataConfig;
const loadExplorerDataProvider = (mlApi, mlResultsService, anomalyExplorerChartsService, timefilter) => {
  return config => {
    if (!isLoadExplorerDataConfig(config)) {
      return (0, _rxjs.of)({});
    }
    const {
      influencersFilterQuery,
      selectedCells,
      selectedJobs,
      viewBySwimlaneFieldName
    } = config;
    const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, viewBySwimlaneFieldName);
    const jobIds = (0, _explorer_utils.getSelectionJobIds)(selectedCells, selectedJobs);
    const bounds = timefilter.getBounds();
    const timerange = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, bounds);

    // Fetch only chart records here; influencers are managed by InfluencersStateService
    return anomalyExplorerChartsService.loadDataForCharts$(jobIds, timerange.earliestMs, timerange.latestMs, selectionInfluencers, selectedCells, influencersFilterQuery).pipe((0, _rxjs.map)(() => ({
      loading: false,
      anomalyChartsDataLoading: false
    })));
  };
};
const useExplorerData = () => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    anomalyExplorerChartsService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const loadExplorerData = (0, _react.useMemo)(() => {
    const mlResultsService = (0, _results_service.mlResultsServiceProvider)(mlApi);
    return loadExplorerDataProvider(mlApi, mlResultsService, anomalyExplorerChartsService, timefilter);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const loadExplorerData$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const explorerData$ = (0, _react.useMemo)(() => loadExplorerData$.pipe((0, _rxjs.switchMap)(loadExplorerData)), []);
  const explorerData = (0, _useObservable.default)(explorerData$);
  const update = (0, _react.useCallback)(c => {
    loadExplorerData$.next(c);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return [explorerData, update];
};
exports.useExplorerData = useExplorerData;