"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobSelectionFlyout = useJobSelectionFlyout;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _storage = require("../../../../common/types/storage");
var _kibana = require("../kibana");
var _job_selector_flyout = require("../../components/job_selector/job_selector_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/contexts/ml/use_job_selection_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Hook for invoking Anomaly Detection jobs selection
 * inside the ML app.
 */
function useJobSelectionFlyout() {
  const {
    overlays,
    services
  } = (0, _kibana.useMlKibana)();
  const [applyTimeRangeConfig, setApplyTimeRangeConfig] = (0, _mlLocalStorage.useStorage)(_storage.ML_APPLY_TIME_RANGE_CONFIG, true);
  const flyoutRef = (0, _react.useRef)();
  (0, _react.useEffect)(function closeFlyoutOnLeave() {
    return () => {
      if (flyoutRef.current) {
        flyoutRef.current.close();
      }
    };
  }, []);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return (0, _react.useCallback)((config = {
    singleSelection: false,
    withTimeRangeSelector: true,
    timeseriesOnly: false,
    selectedIds: []
  }) => {
    const {
      uiSettings
    } = services;
    const tzConfig = uiSettings.get('dateFormat:tz');
    const dateFormatTz = tzConfig !== 'Browser' ? tzConfig : _moment.default.tz.guess();
    return new Promise(async (resolve, reject) => {
      try {
        flyoutRef.current = overlays.openFlyout(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: services,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_job_selector_flyout.JobSelectorFlyoutContent, {
          flyoutTitleId: flyoutTitleId,
          selectedIds: config.selectedIds,
          withTimeRangeSelector: config.withTimeRangeSelector,
          applyTimeRangeConfig: applyTimeRangeConfig,
          onTimeRangeConfigChange: setApplyTimeRangeConfig,
          dateFormatTz: dateFormatTz,
          singleSelection: !!config.singleSelection,
          timeseriesOnly: !!config.timeseriesOnly,
          onFlyoutClose: () => {
            reject();
            flyoutRef.current.close();
          },
          onSelectionConfirmed: payload => {
            resolve(payload);
            flyoutRef.current.close();
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 15
          }
        })), {
          'aria-labelledby': flyoutTitleId
        });
      } catch (error) {
        reject(error);
      }
    });
  }, [services, overlays, applyTimeRangeConfig, setApplyTimeRangeConfig, flyoutTitleId]);
}