"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportJobsFlyoutContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _export_job_warning_callout = require("./export_job_warning_callout");
var _kibana = require("../../../contexts/kibana");
var _jobs_export_service = require("./jobs_export_service");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/import_export_jobs/export_jobs_flyout/export_jobs_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LoadingSpinner = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceAround",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 9
  }
}))));
const ExportJobsFlyoutContent = ({
  currentTab,
  isADEnabled,
  isDFAEnabled,
  onClose
}) => {
  const {
    services: {
      notifications: {
        toasts
      },
      mlServices: {
        mlUsageCollection,
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    getJobs,
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = mlApi;
  const jobsExportService = (0, _react.useMemo)(() => new _jobs_export_service.JobsExportService(mlApi), [mlApi]);
  const [adJobIds, setAdJobIds] = (0, _react.useState)([]);
  const [dfaJobIds, setDfaJobIds] = (0, _react.useState)([]);
  const [selectedJobIds, setSelectedJobIds] = (0, _react.useState)([]);
  const [selectedJobType, setSelectedJobType] = (0, _react.useState)(currentTab);
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _react.useMemo)(() => (0, _toast_notification_service.toastNotificationServiceProvider)(toasts), [toasts]);
  const [jobDependencies, setJobDependencies] = (0, _react.useState)([]);
  const [loadingADJobs, setLoadingADJobs] = (0, _react.useState)(true);
  const [loadingDFAJobs, setLoadingDFAJobs] = (0, _react.useState)(true);
  const [exporting, setExporting] = (0, _react.useState)(false);
  const [selectedJobDependencies, setSelectedJobDependencies] = (0, _react.useState)([]);
  async function onExport() {
    setExporting(true);
    const title = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportDownloading', {
      defaultMessage: 'Your file is downloading in the background'
    });
    displaySuccessToast(title);
    try {
      if (selectedJobType === 'anomaly-detector') {
        await jobsExportService.exportAnomalyDetectionJobs(selectedJobIds);
      } else {
        await jobsExportService.exportDataframeAnalyticsJobs(selectedJobIds);
      }
      mlUsageCollection.count(selectedJobType === 'anomaly-detector' ? 'exported_anomaly_detector_jobs' : 'exported_data_frame_analytics_jobs', selectedJobIds.length);
      setExporting(false);
      onClose();
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportError', {
        defaultMessage: 'Could not export selected jobs'
      });
      displayErrorToast(error, errorTitle);
      setExporting(false);
    }
  }
  function toggleSelectedJob(checked, id) {
    if (checked) {
      setSelectedJobIds([...selectedJobIds, id]);
    } else {
      setSelectedJobIds(selectedJobIds.filter(id2 => id2 !== id));
    }
  }
  function onSelectAll() {
    const ids = selectedJobType === 'anomaly-detector' ? adJobIds : dfaJobIds;
    if (selectedJobIds.length === ids.length) {
      setSelectedJobIds([]);
    } else {
      setSelectedJobIds([...ids]);
    }
  }
  (0, _react.useEffect)(() => {
    setSelectedJobDependencies(jobDependencies.filter(({
      jobId
    }) => selectedJobIds.includes(jobId)));
  }, [jobDependencies, selectedJobIds]);
  (0, _react.useEffect)(function onFlyoutChange() {
    setLoadingADJobs(true);
    setLoadingDFAJobs(true);
    setExporting(false);
    setAdJobIds([]);
    setSelectedJobIds([]);
    setSelectedJobType(currentTab);
    if (isADEnabled) {
      getJobs().then(({
        jobs
      }) => {
        setLoadingADJobs(false);
        setAdJobIds(jobs.map(j => j.job_id));
        jobsExportService.getJobDependencies(jobs).then(jobDeps => {
          setJobDependencies(jobDeps);
          setLoadingADJobs(false);
        }).catch(error => {
          const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.calendarsError', {
            defaultMessage: 'Could not load calendars'
          });
          displayErrorToast(error, errorTitle);
        });
      }).catch(error => {
        const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.adJobsError', {
          defaultMessage: 'Could not load anomaly detection jobs'
        });
        displayErrorToast(error, errorTitle);
      });
    }
    if (isDFAEnabled) {
      getDataFrameAnalytics().then(({
        data_frame_analytics: dataFrameAnalytics
      }) => {
        setLoadingDFAJobs(false);
        setDfaJobIds(dataFrameAnalytics.map(j => j.id));
      }).catch(error => {
        const errorTitle = _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.dfaJobsError', {
          defaultMessage: 'Could not load data frame analytics jobs'
        });
        displayErrorToast(error, errorTitle);
      });
    }
  }, [currentTab, displayErrorToast, getDataFrameAnalytics, getJobs, isADEnabled, isDFAEnabled, jobsExportService]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    hideCloseButton: true,
    size: "s",
    "data-test-subj": "mlJobMgmtExportJobsFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.flyoutHeader",
    defaultMessage: "Export {selectedMLType} jobs",
    values: {
      selectedMLType: currentTab === 'anomaly-detector' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.importExport.exportFlyout.adTab",
        defaultMessage: "Anomaly detection",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 23
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.importExport.exportFlyout.dfaTab",
        defaultMessage: "Analytics",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 23
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_export_job_warning_callout.ExportJobDependenciesWarningCallout, {
    jobs: selectedJobDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isADEnabled === true && selectedJobType === 'anomaly-detector' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loadingADJobs === true ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onSelectAll,
    "data-test-subj": "mlJobMgmtExportJobsSelectAllButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 21
    }
  }, selectedJobIds.length === adJobIds.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.adDeselectAllButton",
    defaultMessage: "Deselect all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.adSelectAllButton",
    defaultMessage: "Select all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtExportJobsADJobList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 21
    }
  }, adJobIds.map(id => /*#__PURE__*/_react.default.createElement("div", {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: id,
    checked: selectedJobIds.includes(id),
    onChange: e => toggleSelectedJob(e.target.checked, id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 27
    }
  })))))), isDFAEnabled === true && selectedJobType === 'data-frame-analytics' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loadingDFAJobs === true ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onSelectAll,
    "data-test-subj": "mlJobMgmtExportJobsSelectAllButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 21
    }
  }, selectedJobIds.length === dfaJobIds.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.dfaDeselectAllButton",
    defaultMessage: "Deselect all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.dfaSelectAllButton",
    defaultMessage: "Select all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlJobMgmtExportJobsDFAJobList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 21
    }
  }, dfaJobIds.map(id => /*#__PURE__*/_react.default.createElement("div", {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: id,
    label: id,
    checked: selectedJobIds.includes(id),
    onChange: e => toggleSelectedJob(e.target.checked, id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 27
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose.bind(null),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: selectedJobIds.length === 0 || exporting === true,
    onClick: onExport,
    fill: true,
    "data-test-subj": "mlJobMgmtExportExportButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.exportButton",
    defaultMessage: "Export",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 17
    }
  })))))));
};
exports.ExportJobsFlyoutContent = ExportJobsFlyoutContent;