"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataRecognizer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _recognized_result = require("./recognized_result");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/data_recognizer/data_recognizer.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DataRecognizer extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      results: []
    };
    this.indexPattern = props.indexPattern;
    this.savedSearch = props.savedSearch;
    this.className = props.className;
    this.results = props.results;
  }
  componentDidMount() {
    const mlApi = this.context.services.mlServices.mlApi;
    // once the mount is complete, call the recognize endpoint to see if the index format is known to us,
    mlApi.recognizeIndex({
      indexPatternTitle: this.indexPattern.title
    }).then(resp => {
      // Sort results by title prior to display
      resp.sort((res1, res2) => res1.title.localeCompare(res2.title));
      const results = resp.map(r => /*#__PURE__*/_react.default.createElement(_recognized_result.RecognizedResult, {
        key: r.id,
        config: r,
        indexPattern: this.indexPattern,
        savedSearch: this.savedSearch,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 11
        }
      }));
      if (typeof this.results === 'object') {
        this.results.count = results.length;
        if (typeof this.results.onChange === 'function') {
          this.results.onChange();
        }
      }
      this.setState({
        results
      });
    }).catch(e => {
      console.error('Error attempting to recognize index', e);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.state.results);
  }
}
exports.DataRecognizer = DataRecognizer;
(0, _defineProperty2.default)(DataRecognizer, "contextType", _public.context);
DataRecognizer.propTypes = {
  indexPattern: _propTypes.default.object,
  savedSearch: _propTypes.default.object,
  className: _propTypes.default.string,
  results: _propTypes.default.object
};