"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTableCellValue = void 0;
exports.getAlertEntryFormatter = getAlertEntryFormatter;
exports.getAlertFormatters = getAlertFormatters;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/field-formats-plugin/common");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _eui = require("@elastic/eui");
var _alerts_table_context = require("@kbn/response-ops-alerts-table/contexts/alerts_table_context");
var _alerts = require("../../../common/constants/alerts");
var _use_field_formatter = require("../../application/contexts/kibana/use_field_formatter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_alerts_table/render_cell_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAlertFieldValue = (alert, fieldName) => {
  // can be updated when working on https://github.com/elastic/kibana/issues/140819
  const rawValue = alert[fieldName];
  const value = Array.isArray(rawValue) ? rawValue.join() : rawValue;
  if (!(0, _lodash.isEmpty)(value)) {
    if (typeof value === 'object') {
      try {
        return JSON.stringify(value);
      } catch (e) {
        return 'Error: Unable to parse JSON value.';
      }
    }
    return value;
  }
  return '--';
};
const AlertsTableCellValue = ({
  columnId,
  alert
}) => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _alerts_table_context.useAlertsTableContext)();
  const alertValueFormatter = getAlertFormatters(fieldFormats);
  const value = getAlertFieldValue(alert, columnId);
  return alertValueFormatter(columnId, value);
};
exports.AlertsTableCellValue = AlertsTableCellValue;
function getAlertFormatters(fieldFormats) {
  const getFormatter = (0, _use_field_formatter.getFieldFormatterProvider)(fieldFormats);
  return (columnId, value) => {
    if (!(0, _mlIsDefined.isDefined)(value)) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '—');
    switch (columnId) {
      case _ruleDataUtils.ALERT_START:
      case _ruleDataUtils.ALERT_END:
      case _alerts.ALERT_ANOMALY_TIMESTAMP:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DATE)(value));
      case _ruleDataUtils.ALERT_DURATION:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DURATION, {
          inputFormat: 'microseconds',
          outputFormat: 'humanizePrecise'
        })(value));
      case _alerts.ALERT_ANOMALY_SCORE:
        let latestValue;
        if (typeof value === 'number') {
          latestValue = value;
        } else {
          const resultValue = value.split(',').map(Number);
          latestValue = resultValue.at(-1);
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          textSize: 'xs',
          color: (0, _mlAnomalyUtils.getSeverityColor)(latestValue),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 11
          }
        }, (0, _mlAnomalyUtils.getFormattedSeverityScore)(latestValue));
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
    }
  };
}
function getAlertEntryFormatter(fieldFormats) {
  const alertValueFormatter = getAlertFormatters(fieldFormats);
  return (columnId, value) => {
    return {
      title: _alerts.alertFieldNameMap[columnId],
      description: alertValueFormatter(columnId, value)
    };
  };
}