"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/cases-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _default_alert_actions = require("@kbn/response-ops-alerts-table/components/default_alert_actions");
var _constants = require("@kbn/response-ops-alerts-table/constants");
var _app = require("../../../common/constants/app");
var _kibana = require("../../application/contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_alerts_table/alert_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertActions = props => {
  var _ref, _alert$ALERT_RULE_UUI, _ref2, _alert$ALERT_UUID, _cases$hooks, _cases$hooks2;
  const {
    alert,
    refresh
  } = props;
  const {
    cases
  } = (0, _kibana.useMlKibana)().services;
  const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases([_common.APP_ID]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const ruleId = (_ref = (_alert$ALERT_RULE_UUI = alert[_ruleDataUtils.ALERT_RULE_UUID]) === null || _alert$ALERT_RULE_UUI === void 0 ? void 0 : _alert$ALERT_RULE_UUI[0]) !== null && _ref !== void 0 ? _ref : null;
  const alertId = (_ref2 = (_alert$ALERT_UUID = alert[_ruleDataUtils.ALERT_UUID]) === null || _alert$ALERT_UUID === void 0 ? void 0 : _alert$ALERT_UUID[0]) !== null && _ref2 !== void 0 ? _ref2 : '';
  const ecsData = (0, _react.useMemo)(() => ({
    _id: alert._id,
    _index: alert._index
  }), [alert._id, alert._index]);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: alertId !== null && alertId !== void 0 ? alertId : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.AttachmentType.alert,
      rule: {
        id: ruleId,
        name: alert[_ruleDataUtils.ALERT_RULE_NAME][0]
      },
      owner: _app.PLUGIN_ID
    }] : [];
  }, [alert, alertId, ecsData === null || ecsData === void 0 ? void 0 : ecsData._id, ecsData === null || ecsData === void 0 ? void 0 : ecsData._index, ruleId]);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
  }, [refresh]);
  const createCaseFlyout = cases === null || cases === void 0 ? void 0 : (_cases$hooks = cases.hooks) === null || _cases$hooks === void 0 ? void 0 : _cases$hooks.useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : (_cases$hooks2 = cases.hooks) === null || _cases$hooks2 === void 0 ? void 0 : _cases$hooks2.useCasesAddToExistingCaseModal({
    onSuccess
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout === null || createCaseFlyout === void 0 ? void 0 : createCaseFlyout.open({
      attachments: caseAttachments
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal === null || selectCaseModal === void 0 ? void 0 : selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
    closeActionsPopover();
  };
  const defaultAlertActions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_default_alert_actions.DefaultAlertActions, (0, _extends2.default)({
    key: "defaultRowActions",
    onActionExecuted: closeActionsPopover,
    isAlertDetailsEnabled: false,
    resolveRulePagePath: alertRuleId => alertRuleId ? `${_constants.STACK_MANAGEMENT_RULE_PAGE_URL_PREFIX}${alertRuleId}` : null
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  })), [props]);
  const actionsMenuItems = [...(casesPrivileges && casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create && casesPrivileges.read ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-existing-case-action",
    key: "addToExistingCase",
    onClick: handleAddToExistingCaseClick,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.alerts.actions.addToCase', {
    defaultMessage: 'Add to existing case'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-new-case-action",
    key: "addToNewCase",
    onClick: handleAddToNewCaseClick,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.alerts.actions.addToNewCase', {
    defaultMessage: 'Add to new case'
  }))] : [])];
  if (defaultAlertActions) {
    actionsMenuItems.push(defaultAlertActions);
  }
  const actionsToolTip = actionsMenuItems.length <= 0 ? _i18n.i18n.translate('xpack.ml.alertsTable.notEnoughPermissions', {
    defaultMessage: 'Additional privileges required'
  }) : _i18n.i18n.translate('xpack.ml.alertsTable.moreActionsTextLabel', {
    defaultMessage: 'More actions'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems,
    "data-test-subj": "alertsTableActionsMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  })));
};
exports.AlertActions = AlertActions;