"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsonSchemaQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getJsonSchemaQuerySchema = exports.getJsonSchemaQuerySchema = _configSchema.schema.object({
  /**
   * ES API path
   */
  path: _configSchema.schema.oneOf([_configSchema.schema.literal('/_ml/anomaly_detectors/{job_id}'), _configSchema.schema.literal('/_ml/datafeeds/{datafeed_id}')]),
  /**
   * API Method
   */
  method: _configSchema.schema.string()
});