"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deduplicateFields = deduplicateFields;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const BASE_FIELD_NAME = 'metrics.';
function deduplicateFields(fields) {
  const map = new Map();
  for (const field of fields) {
    const isMetricsPrefixed = field.name.startsWith(BASE_FIELD_NAME);
    const base = isMetricsPrefixed ? field.name.slice(BASE_FIELD_NAME.length) : field.name;
    if (!map.has(base) || !isMetricsPrefixed) {
      map.set(base, {
        ...field,
        name: base
      });
    }
  }
  return Array.from(map.values());
}