"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynchronizeMovementModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _map_embeddables_singleton = require("../../react_embeddable/map_embeddables_singleton");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/trigger_actions/synchronize_movement/modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SynchronizeMovementModal extends _react.Component {
  _renderSwitches() {
    const mapPanels = _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels();
    const synchronizedPanels = mapPanels.filter(mapPanel => {
      return mapPanel.getIsMovementSynchronized();
    });
    return mapPanels.map(mapPanel => {
      const hasErrors = synchronizedPanels.length === 1 && mapPanel.getIsMovementSynchronized();
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        key: mapPanel.id,
        isInvalid: hasErrors,
        error: hasErrors ? [_i18n.i18n.translate('xpack.maps.synchronizeMovementModal.onlyOneMapSelectedError', {
          defaultMessage: 'Select another map to synchronize map movement'
        })] : [],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: mapPanel.getTitle(),
        checked: mapPanel.getIsMovementSynchronized(),
        onChange: event => {
          const isChecked = event.target.checked;
          if (!isChecked && synchronizedPanels.length === 2) {
            // Auto uncheck last 2 switches when second to last switch is unchecked
            synchronizedPanels.forEach(it => {
              it.setIsMovementSynchronized(false);
            });
          } else if (isChecked && mapPanels.length === 2) {
            // Auto check switches when there is only a pair of maps
            mapPanels.forEach(it => {
              it.setIsMovementSynchronized(true);
            });
          } else {
            mapPanel.setIsMovementSynchronized(isChecked);
          }
          this.forceUpdate();
        },
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.title', {
      defaultMessage: 'Synchronize map movement'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }, this._renderSwitches()));
  }
}
exports.SynchronizeMovementModal = SynchronizeMovementModal;