"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricEditor = MetricEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _metric_select = require("./metric_select");
var _single_field_select = require("../single_field_select");
var _constants = require("../../../common/constants");
var _index_pattern_util = require("../../index_pattern_util");
var _validated_number_input = require("../validated_number_input");
var _mask = require("../../classes/layers/vector_layer/mask");
var _mask_expression = require("./mask_expression");
var _input_strings = require("../../connected_components/input_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/metrics_editor/metric_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function filterFieldsForAgg(fields, aggType) {
  if (!fields) {
    return [];
  }
  if (aggType === _constants.AGG_TYPE.UNIQUE_COUNT || aggType === _constants.AGG_TYPE.TERMS) {
    return (0, _index_pattern_util.getTermsFields)(fields);
  }
  const metricAggFieldTypes = ['number'];
  if (aggType !== _constants.AGG_TYPE.SUM) {
    metricAggFieldTypes.push('date');
  }
  return fields.filter(field => {
    return field.aggregatable && metricAggFieldTypes.includes(field.type) && (field.timeSeriesMetric !== 'counter' || ['min', 'max'].includes(aggType));
  });
}
function MetricEditor({
  bucketsName,
  fields,
  isJoin,
  metricsFilter,
  metric,
  onChange,
  showRemoveButton,
  onRemove
}) {
  const onAggChange = metricAggregationType => {
    if (!metricAggregationType) {
      return;
    }

    // Intentionally not adding mask.
    // Changing aggregation likely changes value range so keeping old mask does not seem relevent
    const descriptor = {
      type: metricAggregationType,
      label: metric.label
    };
    if (metricAggregationType === _constants.AGG_TYPE.COUNT || !('field' in metric) || !metric.field) {
      onChange(descriptor);
      return;
    }
    const fieldsForNewAggType = filterFieldsForAgg(fields, metricAggregationType);
    const found = fieldsForNewAggType.find(field => field.name === metric.field);
    const newDescriptor = {
      ...descriptor,
      field: found ? metric.field : undefined
    };
    if (metricAggregationType === _constants.AGG_TYPE.PERCENTILE) {
      onChange({
        ...newDescriptor,
        percentile: 'percentile' in metric ? metric.percentile : _constants.DEFAULT_PERCENTILE
      });
    } else {
      onChange(newDescriptor);
    }
  };
  const onFieldChange = fieldName => {
    if (!fieldName || metric.type === _constants.AGG_TYPE.COUNT) {
      return;
    }
    // Intentionally not adding mask.
    // Changing field likely changes value range so keeping old mask does not seem relevent
    onChange({
      label: metric.label,
      type: metric.type,
      field: fieldName
    });
  };
  const onPercentileChange = percentile => {
    if (metric.type !== _constants.AGG_TYPE.PERCENTILE) {
      return;
    }
    onChange({
      ...metric,
      percentile
    });
  };
  const onLabelChange = e => {
    onChange({
      ...metric,
      label: e.target.value
    });
  };
  let fieldSelect;
  if (metric.type && metric.type !== _constants.AGG_TYPE.COUNT) {
    const showErrors = metric.field === undefined;
    fieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.metricsEditor.selectFieldLabel', {
        defaultMessage: 'Field'
      }),
      display: "columnCompressed",
      isInvalid: showErrors,
      error: _i18n.i18n.translate('xpack.maps.metricsEditor.selectFieldError', {
        defaultMessage: 'Field required for aggregation'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _input_strings.inputStrings.fieldSelectPlaceholder,
      value: metric.field ? metric.field : null,
      onChange: onFieldChange,
      fields: filterFieldsForAgg(fields, metric.type),
      isClearable: false,
      isInvalid: showErrors,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }));
  }
  let percentileSelect;
  if (metric.type === _constants.AGG_TYPE.PERCENTILE) {
    const label = _i18n.i18n.translate('xpack.maps.metricsEditor.selectPercentileLabel', {
      defaultMessage: 'Percentile'
    });
    percentileSelect = /*#__PURE__*/_react.default.createElement(_validated_number_input.ValidatedNumberInput, {
      min: 0,
      max: 100,
      onChange: onPercentileChange,
      label: label,
      initialValue: typeof metric.percentile === 'number' ? metric.percentile : _constants.DEFAULT_PERCENTILE,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    });
  }
  let labelInput;
  if (metric.type) {
    labelInput = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.metricsEditor.customLabel', {
        defaultMessage: 'Custom label'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      onChange: onLabelChange,
      value: metric.label ? metric.label : '',
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }));
  }
  let removeButton;
  if (showRemoveButton) {
    removeButton = /*#__PURE__*/_react.default.createElement("div", {
      className: "mapMetricEditorPanel__metricRemoveButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "trash",
      size: "xs",
      color: "danger",
      onClick: onRemove,
      "aria-label": _i18n.i18n.translate('xpack.maps.metricsEditor.deleteMetricAriaLabel', {
        defaultMessage: 'Delete metric'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.metricsEditor.deleteMetricButtonLabel",
      defaultMessage: "Delete metric",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.metricsEditor.aggregationLabel', {
      defaultMessage: 'Aggregation'
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    onChange: onAggChange,
    value: metric.type,
    metricsFilter: metricsFilter,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  })), fieldSelect, percentileSelect, labelInput, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _mask.getMaskI18nLabel)({
      bucketsName,
      isJoin
    }),
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mask_expression.MaskExpression, {
    fields: fields,
    isJoin: isJoin,
    metric: metric,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  })), removeButton);
}