"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTSingleLayerSourceSettings = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _mvt_field_config_editor = require("./mvt_field_config_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/mvt_single_layer_vector_source/mvt_single_layer_source_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/consistent-type-definitions */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MVTSingleLayerSourceSettings extends _react.Component {
  constructor(...args) {
    super(...args);
    // Tracking in state to allow for debounce.
    // Changes to layer-name and/or min/max zoom require heavy operation at map-level (removing and re-adding all sources/layers)
    // To preserve snappyness of typing, debounce the dispatches.
    (0, _defineProperty2.default)(this, "state", {
      currentLayerName: this.props.layerName,
      currentMinSourceZoom: this.props.minSourceZoom,
      currentMaxSourceZoom: this.props.maxSourceZoom,
      currentFields: _lodash.default.cloneDeep(this.props.fields)
    });
    (0, _defineProperty2.default)(this, "_handleChange", _lodash.default.debounce(() => {
      this.props.handleChange({
        layerName: this.state.currentLayerName,
        minSourceZoom: this.state.currentMinSourceZoom,
        maxSourceZoom: this.state.currentMaxSourceZoom,
        fields: this.state.currentFields
      });
    }, 200));
    (0, _defineProperty2.default)(this, "_handleLayerNameInputChange", e => {
      this.setState({
        currentLayerName: e.target.value
      }, this._handleChange);
    });
    (0, _defineProperty2.default)(this, "_handleFieldChange", fields => {
      this.setState({
        currentFields: fields
      }, this._handleChange);
    });
    (0, _defineProperty2.default)(this, "_handleZoomRangeChange", e => {
      this.setState({
        currentMinSourceZoom: parseInt(e[0], 10),
        currentMaxSourceZoom: parseInt(e[1], 10)
      }, this._handleChange);
    });
  }
  render() {
    const preMessage = _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsPreHelpMessage', {
      defaultMessage: 'Fields which are available in '
    });
    const message = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, this.state.currentLayerName), ".", ' ');
    const postMessage = _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsPostHelpMessage', {
      defaultMessage: 'These can be used for tooltips and dynamic styling.'
    });
    const fieldEditor = this.props.showFields && this.state.currentLayerName !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.fieldsMessage', {
        defaultMessage: 'Fields'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        color: "subdued",
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, preMessage, message, postMessage),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 15
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_mvt_field_config_editor.MVTFieldConfigEditor, {
      fields: this.state.currentFields.slice(),
      onChange: this._handleFieldChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.layerNameMessage', {
        defaultMessage: 'Source layer'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.currentLayerName,
      onChange: this._handleLayerNameInputChange,
      isInvalid: this.state.currentLayerName === '',
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
      label: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.zoomRangeTopMessage', {
        defaultMessage: 'Available levels'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        color: "subdued",
        content: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.zoomRangeHelpMessage', {
          defaultMessage: 'Zoom levels where the layer is present in the tiles. This does not correspond directly to visibility. Layer data from lower levels can always be displayed at higher zoom levels (but not vice versa).'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 15
        }
      })),
      formRowDisplay: "columnCompressed",
      value: [this.state.currentMinSourceZoom, this.state.currentMaxSourceZoom],
      min: _constants.MIN_ZOOM,
      max: _constants.MAX_ZOOM,
      onChange: this._handleZoomRangeChange,
      allowEmptyRange: false,
      showInput: "inputWithPopover",
      compressed: true,
      showLabels: true,
      prepend: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.dataZoomRangeMessage', {
        defaultMessage: 'Zoom'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }), fieldEditor);
  }
}
exports.MVTSingleLayerSourceSettings = MVTSingleLayerSourceSettings;