"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLinePanel = exports.FillSetting = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _visualizationUtils = require("@kbn/visualization-utils");
var _palettes = require("@kbn/palettes");
var _icon_set = require("../../../../shared_components/icon_set");
var _ = require("..");
var _dimension_editor = require("../dimension_editor");
var _state_helpers = require("../../state_helpers");
var _marker_decoration_settings = require("../shared/marker_decoration_settings");
var _color_assignment = require("../../color_assignment");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/reference_line_config_panel/reference_line_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReferenceLinePanel = props => {
  var _localLayer$yConfig;
  const {
    state,
    setState,
    layerId,
    accessor
  } = props;
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const localLayer = localState.layers.find(l => l.layerId === layerId);
  const localConfig = localLayer === null || localLayer === void 0 ? void 0 : (_localLayer$yConfig = localLayer.yConfig) === null || _localLayer$yConfig === void 0 ? void 0 : _localLayer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor);
  const setConfig = (0, _react.useCallback)(yConfig => {
    if (yConfig == null) {
      return;
    }
    const newYConfigs = [...(localLayer.yConfig || [])];
    const existingIndex = newYConfigs.findIndex(yAxisConfig => yAxisConfig.forAccessor === accessor);
    if (existingIndex !== -1) {
      newYConfigs[existingIndex] = {
        ...newYConfigs[existingIndex],
        ...yConfig
      };
    } else {
      newYConfigs.push({
        forAccessor: accessor,
        ...yConfig
      });
    }
    setLocalState((0, _.updateLayer)(localState, {
      ...localLayer,
      yConfig: newYConfigs
    }, index));
  }, [accessor, index, localState, localLayer, setLocalState]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.TextDecorationSetting, {
    idPrefix: _dimension_editor.idPrefix,
    setConfig: setConfig,
    currentConfig: localConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.IconSelectSetting, {
    setIcon: icon => setConfig({
      icon
    }),
    currentIcon: localConfig === null || localConfig === void 0 ? void 0 : localConfig.icon,
    customIconSet: _icon_set.referenceLineIconsSet,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.MarkerDecorationPosition, {
    isHorizontal: isHorizontal,
    setConfig: setConfig,
    currentConfig: localConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.LineStyleSettings, {
    idPrefix: _dimension_editor.idPrefix,
    setConfig: setConfig,
    currentConfig: localConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(FillSetting, {
    isHorizontal: isHorizontal,
    setConfig: setConfig,
    currentConfig: localConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: localConfig === null || localConfig === void 0 ? void 0 : localConfig.color,
    defaultColor: _color_assignment.defaultReferenceLineColor,
    setConfig: setConfig,
    disableHelpTooltip: true,
    swatches: props.palettes.get(_palettes.KbnPalette.Default).colors(10),
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineColor.label', {
      defaultMessage: 'Color'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  })));
};
exports.ReferenceLinePanel = ReferenceLinePanel;
function getFillPositionOptions({
  isHorizontal,
  axisMode
}) {
  const aboveLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.above', {
    defaultMessage: 'Above'
  });
  const belowLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.below', {
    defaultMessage: 'Below'
  });
  const beforeLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.before', {
    defaultMessage: 'Before'
  });
  const afterLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.after', {
    defaultMessage: 'After'
  });
  const aboveOptionLabel = axisMode !== 'bottom' && !isHorizontal ? aboveLabel : afterLabel;
  const belowOptionLabel = axisMode !== 'bottom' && !isHorizontal ? belowLabel : beforeLabel;
  return [{
    id: `${_dimension_editor.idPrefix}none`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.fill.none', {
      defaultMessage: 'None'
    }),
    'data-test-subj': 'lnsXY_fill_none'
  }, {
    id: `${_dimension_editor.idPrefix}above`,
    label: aboveOptionLabel,
    'data-test-subj': 'lnsXY_fill_above'
  }, {
    id: `${_dimension_editor.idPrefix}below`,
    label: belowOptionLabel,
    'data-test-subj': 'lnsXY_fill_below'
  }];
}
const FillSetting = ({
  currentConfig,
  setConfig,
  isHorizontal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.fill.label', {
      defaultMessage: 'Fill'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.fill.label', {
      defaultMessage: 'Fill'
    }),
    "data-test-subj": "lnsXY_fill",
    buttonSize: "compressed",
    options: getFillPositionOptions({
      isHorizontal,
      axisMode: currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.axisMode
    }),
    idSelected: `${_dimension_editor.idPrefix}${(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.fill) || 'none'}`,
    onChange: id => {
      const newMode = id.replace(_dimension_editor.idPrefix, '');
      setConfig({
        fill: newMode
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }));
};
exports.FillSetting = FillSetting;