"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnlinkLayerAction = void 0;
var _i18n = require("@kbn/i18n");
var _visualization_helpers = require("../../visualization_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUnlinkLayerAction = ({
  state,
  layer,
  setState,
  toasts
}) => {
  return {
    execute: () => {
      const unlinkedLayer = {
        layerId: layer.layerId,
        layerType: layer.layerType,
        indexPatternId: layer.indexPatternId,
        ignoreGlobalFilters: layer.ignoreGlobalFilters,
        annotations: layer.annotations
      };
      setState({
        ...state,
        layers: state.layers.map(layerToCheck => layerToCheck.layerId === layer.layerId ? unlinkedLayer : layerToCheck)
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.lens.xyChart.annotations.notificationUnlinked', {
        defaultMessage: `Unlinked "{title}"`,
        values: {
          title: (0, _visualization_helpers.getAnnotationLayerTitle)(layer)
        }
      }));
    },
    description: _i18n.i18n.translate('xpack.lens.xyChart.annotations.unlinksFromLibrary', {
      defaultMessage: 'Saves the annotation group as a part of the Lens Saved Object'
    }),
    displayName: _i18n.i18n.translate('xpack.lens.xyChart.annotations.unlinkFromLibrary', {
      defaultMessage: 'Unlink from library'
    }),
    isCompatible: true,
    icon: 'unlink',
    'data-test-subj': 'lnsXY_annotationLayer_unlinkFromLibrary',
    order: 300
  };
};
exports.getUnlinkLayerAction = getUnlinkLayerAction;