"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Filtering = Filtering;
exports.setFilter = setFilter;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _operations = require("../operations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/filtering.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function setFilter(columnId, layer, query) {
  return {
    ...layer,
    columns: {
      ...layer.columns,
      [columnId]: {
        ...layer.columns[columnId],
        filter: query
      }
    }
  };
}
function Filtering({
  selectedColumn,
  columnId,
  layer,
  updateLayer,
  indexPattern,
  helpMessage
}) {
  const inputFilter = selectedColumn.filter;
  const onChange = (0, _react.useCallback)(query => {
    const {
      isValid
    } = (0, _visualizationUiComponents.validateQuery)(query, indexPattern);
    if (isValid && !(0, _lodash.isEqual)(inputFilter, query)) {
      updateLayer(setFilter(columnId, layer, query));
    }
  }, [columnId, indexPattern, inputFilter, layer, updateLayer]);
  const lensServices = (0, _public.useKibana)().services;
  const selectedOperation = _operations.operationDefinitionMap[selectedColumn.operationType];
  if (!selectedOperation.filterable) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.FilterQueryInput, {
    helpMessage: helpMessage,
    onChange: onChange,
    dataView: indexPattern,
    inputFilter: inputFilter,
    queryInputServices: lensServices,
    appName: _constants.LENS_APP_NAME,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
}