"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownFactory = exports.default = exports.Markdown = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _markdownIt = _interopRequireDefault(require("markdown-it"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _markdownStyles = require("./markdownStyles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/markdown/markdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Return a memoized markdown rendering function that use the specified
 * whiteListedRules and openLinksInNewTab configurations.
 * @param {Array of Strings} whiteListedRules - white list of markdown rules
 * list of rules can be found at https://github.com/markdown-it/markdown-it/issues/361
 * @param {Boolean} openLinksInNewTab
 * @return {Function} Returns an Object to use with dangerouslySetInnerHTML
 * with the rendered markdown HTML
 */
const markdownFactory = exports.markdownFactory = (0, _lodash.memoize)((whiteListedRules = [], openLinksInNewTab = false) => {
  let markdownIt;

  // It is imperative that the html config property be set to false, to mitigate XSS: the output of markdown-it is
  // fed directly to the DOM via React's dangerouslySetInnerHTML below.

  if (whiteListedRules && whiteListedRules.length > 0) {
    markdownIt = new _markdownIt.default('zero', {
      html: false,
      linkify: true
    });
    markdownIt.enable(whiteListedRules);
  } else {
    markdownIt = new _markdownIt.default({
      html: false,
      linkify: true
    });
  }
  if (openLinksInNewTab) {
    // All links should open in new browser tab.
    // Define custom renderer to add 'target' attribute
    // https://github.com/markdown-it/markdown-it/blob/master/docs/architecture.md#renderer
    const originalLinkRender = markdownIt.renderer.rules.link_open || function (tokens, idx, options, env, self) {
      return self.renderToken(tokens, idx, options);
    };
    markdownIt.renderer.rules.link_open = function (tokens, idx, options, env, self) {
      const href = tokens[idx].attrGet('href');
      const target = '_blank';
      const rel = (0, _eui.getSecureRelForTarget)({
        href: href === null ? undefined : href,
        target
      });

      // https://www.jitbit.com/alexblog/256-targetblank---the-most-underestimated-vulnerability-ever/
      tokens[idx].attrPush(['target', target]);
      if (rel) {
        tokens[idx].attrPush(['rel', rel]);
      }
      return originalLinkRender(tokens, idx, options, env, self);
    };
  }
  /**
   * This method is used to render markdown from the passed parameter
   * into HTML. It will just return an empty string when the markdown is empty.
   * @param {String} markdown - The markdown String
   * @return {String} - Returns the rendered HTML as string.
   */
  return markdown => {
    return markdown ? markdownIt.render(markdown) : '';
  };
}, (whiteListedRules = [], openLinksInNewTab = false) => {
  return `${whiteListedRules.join('_')}${openLinksInNewTab}`;
});
const Markdown = props => {
  (0, _react.useEffect)(() => {
    var _props$onRender;
    (_props$onRender = props.onRender) === null || _props$onRender === void 0 ? void 0 : _props$onRender.call(props);
  }, [props]);
  const {
    className,
    markdown = '',
    openLinksInNewTab,
    whiteListedRules,
    isReversed = false,
    ...rest
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const classes = (0, _classnames.default)('kbnMarkdown__body', {
    'kbnMarkdown__body--reversed': isReversed
  }, className);
  const markdownRenderer = markdownFactory(whiteListedRules, openLinksInNewTab);
  const renderedMarkdown = markdownRenderer(markdown);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: classes,
    css: (0, _markdownStyles.markdownStyles)(euiTheme, isReversed)
    /*
     * Justification for dangerouslySetInnerHTML:
     * The Markdown Visualization is, believe it or not, responsible for rendering Markdown.
     * This relies on `markdown-it` to produce safe and correct HTML.
     */,
    dangerouslySetInnerHTML: {
      __html: renderedMarkdown
    } // eslint-disable-line react/no-danger
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }));
};

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.Markdown = Markdown;
var _default = exports.default = Markdown;