"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElementFromPoint = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the topmost HTML element at the given mouse event's coordinates.
 * @param {MouseEvent} event The mouse event containing the coordinates.
 * @return {HTMLElement | null} The topmost inspectable HTML element at the event's coordinates, or null if none found.
 */
const getElementFromPoint = event => {
  const elements = document.elementsFromPoint(event.clientX, event.clientY);
  for (const el of elements) {
    const isSvg = el instanceof SVGElement;
    const isOverlay = el.id === _constants.INSPECT_OVERLAY_ID;
    const isPath = isSvg && el.tagName.toLowerCase() === 'path';
    const isNotInspectable = !(el instanceof HTMLElement) && !isSvg;
    if (isNotInspectable || isOverlay || isPath) continue;
    return isSvg ? el.parentElement : el;
  }
  return null;
};
exports.getElementFromPoint = getElementFromPoint;