"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineRequestFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_form/pipeline_request_flyout/pipeline_request_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PipelineRequestFlyout = ({
  closeFlyout,
  readProcessors
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const form = (0, _shared_imports.useFormContext)();
  const [formData, setFormData] = (0, _react.useState)({});
  const pipeline = {
    ...formData,
    ...readProcessors()
  };
  (0, _react.useEffect)(() => {
    const subscription = form.subscribe(async ({
      isValid,
      validate,
      data
    }) => {
      const isFormValid = isValid !== null && isValid !== void 0 ? isValid : await validate();
      if (isFormValid) {
        setFormData(data.format());
      }
    });
    return subscription.unsubscribe;
  }, [form]);
  const {
    name,
    ...pipelineBody
  } = pipeline;
  const endpoint = `PUT _ingest/pipeline/${name || '<pipelineName>'}`;
  const request = `${endpoint}\n${JSON.stringify(pipelineBody, null, 2)}`;
  const title = name ? _i18n.i18n.translate('xpack.ingestPipelines.requestFlyout.namedTitle', {
    defaultMessage: "Request for ''{name}''",
    values: {
      name
    }
  }) : _i18n.i18n.translate('xpack.ingestPipelines.requestFlyout.unnamedTitle', {
    defaultMessage: 'Request'
  });
  return /*#__PURE__*/_react.default.createElement(_shared_imports.ViewApiRequestFlyout, {
    title: title,
    description: _i18n.i18n.translate('xpack.ingestPipelines.requestFlyout.descriptionText', {
      defaultMessage: 'This Elasticsearch request will create or update the pipeline.'
    }),
    request: request,
    closeFlyout: closeFlyout,
    flyoutProps: {
      maxWidth: 550
    },
    application: services.application,
    urlService: services.share.url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
exports.PipelineRequestFlyout = PipelineRequestFlyout;