"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Remove = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/remove.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFieldConfig = toggleField => ({
  fields_to_remove: {
    path: 'fields.field',
    config: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: v => v.length === 1 ? v[0] : v,
      fieldsToValidateOnChange: ['fields.field', 'fields.keep'],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameField', {
        defaultMessage: 'Fields to remove'
      }),
      helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameHelpText', {
        defaultMessage: 'You can use plain text or template snippets.'
      }),
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.keep'])) {
            return {
              path,
              message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.fieldNameRequiredError', {
                defaultMessage: 'A value is required.'
              })
            };
          }
        }
      }]
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleField,
      "data-test-subj": "toggleRemoveField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.removeForm.defineFieldsToKeepLabel",
      defaultMessage: "Define fields to keep instead",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }))),
    key: 'field'
  },
  fields_to_keep: {
    path: 'fields.keep',
    config: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      deserializer: _shared.to.arrayOfStrings,
      serializer: v => v.length === 1 ? v[0] : v,
      fieldsToValidateOnChange: ['fields.field', 'fields.keep'],
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.keepNameField', {
        defaultMessage: 'Fields to keep'
      }),
      helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.keepNameHelpText', {
        defaultMessage: 'All fields other than those specified will be removed.'
      }),
      validations: [{
        validator: ({
          value,
          path,
          formData
        }) => {
          if ((0, _lodash.isEmpty)(value) && (0, _lodash.isEmpty)(formData['fields.field'])) {
            return {
              path,
              message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.removeForm.keepNameRequiredError', {
                defaultMessage: 'A value is required.'
              })
            };
          }
        }
      }]
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleField,
      "data-test-subj": "toggleRemoveField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.removeForm.defineFieldsToRemoveLabel",
      defaultMessage: "Define fields to remove instead",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }))),
    key: 'keep'
  }
});
const Remove = () => {
  const {
    getFieldDefaultValue
  } = (0, _shared_imports.useFormContext)();
  const isFieldsToKeepFieldDefined = getFieldDefaultValue('fields.keep') !== undefined;
  const [isFieldsToKeep, setIsFieldsToKeep] = (0, _react.useState)(isFieldsToKeepFieldDefined);
  const toggleRemoveField = (0, _react.useCallback)(() => {
    setIsFieldsToKeep(prev => !prev);
  }, []);
  const FieldProps = (0, _react.useMemo)(() => isFieldsToKeep ? getFieldConfig(toggleRemoveField).fields_to_keep : getFieldConfig(toggleRemoveField).fields_to_remove, [isFieldsToKeep, toggleRemoveField]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, (0, _extends2.default)({}, FieldProps, {
    component: _shared_imports.ComboBoxField,
    "data-test-subj": "fieldNameField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }));
};
exports.Remove = Remove;