"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpLocation = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _properties_field = require("./common_fields/properties_field");
var _utils = require("../../../../../sections/manage_processors/utils");
var _constants = require("../../../../../sections/manage_processors/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/ip_location.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const extension = '.mmdb';
const fieldsConfig = {
  /* Optional field config */
  database_file: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: v => _shared.to.arrayOfStrings(v).map(str => {
      var _getDatabaseText;
      const databaseName = str === null || str === void 0 ? void 0 : str.split(extension)[0];
      // Use the translated text for this database, if it exists
      return (_getDatabaseText = (0, _utils.getDatabaseText)(databaseName)) !== null && _getDatabaseText !== void 0 ? _getDatabaseText : databaseName;
    }),
    serializer: v => {
      if (v.length) {
        const databaseName = v[0];
        const databaseValue = (0, _utils.getDatabaseValue)(databaseName);
        return databaseValue ? `${databaseValue}${extension}` : `${databaseName}${extension}`;
      }
      return undefined;
    },
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.databaseFileLabel', {
      defaultMessage: 'Database file (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.ipLocationForm.databaseFileHelpText",
      defaultMessage: "GeoIP2 database file in the {ingestGeoIP} configuration directory. Defaults to {databaseFile}.",
      values: {
        databaseFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 25
          }
        }, 'GeoLite2-City.mmdb'),
        ingestGeoIP: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 24
          }
        }, 'ingest-geoip')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    })
  },
  first_only: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.firstOnlyFieldLabel', {
      defaultMessage: 'First only'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.firstOnlyFieldHelpText', {
      defaultMessage: 'Use the first matching geo data, even if the field contains an array.'
    })
  }
};
const IpLocation = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const {
    data,
    isLoading
  } = services.api.useLoadDatabases();
  const dataAsOptions = (data || []).map(item => {
    var _getDatabaseText2;
    return {
      id: item.id,
      type: item.type,
      // Use the translated text for this database, if it exists
      label: (_getDatabaseText2 = (0, _utils.getDatabaseText)(item.name)) !== null && _getDatabaseText2 !== void 0 ? _getDatabaseText2 : item.name
    };
  });
  const optionsByGroup = (0, _lodash.groupBy)(dataAsOptions, 'type');
  const groupedOptions = (0, _lodash.map)(optionsByGroup, (items, groupName) => ({
    label: (0, _constants.getTypeLabel)(groupName),
    options: (0, _lodash.map)(items, item => item)
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.fieldNameHelpText', {
      defaultMessage: 'Field containing an IP address for the geographical lookup.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.targetFieldHelpText', {
      defaultMessage: 'Field used to contain geo data properties.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ComboBoxField,
    config: fieldsConfig.database_file,
    path: "fields.database_file",
    euiFieldProps: {
      isLoading,
      noSuggestions: false,
      singleSelection: {
        asPlainText: true
      },
      options: groupedOptions
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_properties_field.PropertiesField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.ipLocationForm.propertiesFieldHelpText', {
      defaultMessage: 'Properties added to the target field. Valid properties depend on the database file used.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _shared_imports.ToggleField,
    config: fieldsConfig.first_only,
    path: "fields.first_only",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
};
exports.IpLocation = IpLocation;